class PjcCarfareLogic < BusinessLogic
  def postprocess(action, user, x)
    unless action == :destroy
      if action == :create
        x.applicant_id = user.person.id
      end
      header_summary = 0
      details = PjcCarfareDetail.find_all_by_carfare_id(x.id)
      details.each do |d|
        d.total_amount = d.fare
        if d.one_way_or_round_trip == "2"
          d.total_amount = d.total_amount * 2
        end
        d.exclude_tax_amount = TaxCalculation.compute_net_of_tax(d.total_amount,x.account_item_id,Date.today.strftime("%Y%m%d"))
        d.tax = d.total_amount - d.exclude_tax_amount
        d.save!

        header_summary += d.total_amount
      end
      x.total_amount = header_summary
      x.save!
    end
    return true
  end
end
