class PjcLendExpenseLogic < BusinessLogic
  def postprocess(action, user, x)
    unless action == :destroy
      if action == :create
        x.applicant_id = user.person.id
      end
      header_summary = 0
      details = PjcLendExpensesDetail.find_all_by_lend_expense_id(x.id)
      details.each do |d|
        d.exclude_tax_amount = TaxCalculation.compute_net_of_tax(d.amount,d.account_item_id,Date.today.strftime("%Y%m%d"))
        d.tax = d.amount - d.exclude_tax_amount
        d.save!
        header_summary += d.amount
      end
      x.total_amount = header_summary
      x.save!
    end
    return true
  end
end
