# To change this template, choose Tools | Templates
# and open the template in the editor.

module ConfigOutput::PjcTaskPjList
  def output_rows(display_id, options, session_readonly)
    result = []
    options.update(:select => "tasks.*,
                               task_evm_totals.delayed_days_before_start,
                               task_evm_totals.delayed_days_until_finish,
                               task_evm_totals.plan_progress_rate,
                               task_evm_totals.planed_value,
                               task_evm_totals.earned_value,
                               task_evm_totals.schedule_variance,
                               task_evm_totals.schedule_performance_index,
                               task_evm_totals.cost_variance,
                               task_evm_totals.cost_performance_index,
                               task_evm_totals.estimate_to_comlete,
                               task_evm_totals.estimate_at_completion,
                               task_evm_totals.variance_at_completion")
    options.update(:joins => "LEFT OUTER JOIN task_evm_totals ON tasks.id = task_evm_totals.task_id")
    options.update(:order => "tasks.project_id, tasks.segment_id, tasks.lft,task_evm_totals.total_date")
    options[:conditions] ="tasks.data_type='segment'"
    selects =[]
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      selects << output_item.item.column_name
    end

    PjcTask.find(:all, :conditions => options[:conditions],
                       :order => options[:order_by] || options[:order],
                       :joins => options[:join] || options[:joins],
                       :include => options[:include],
                       :select => options[:select],
                       :group => options[:group]).each do |pre_row|
                       cols = []
                       cols << pre_row.id
                       selects.each do |col|
                         case col
                         when "name"
                           if pre_row.project_name !=""&&pre_row.segment_name !=""
                             cols << ("#{pre_row.project_code}/#{pre_row.project_name}/#{pre_row.segment_name}")
                           else
                             cols << ""
                           end
                         when "planned_start_date"
                           cols << date_change(pre_row, col)
                         when "planned_finish_date"
                           cols << date_change(pre_row, col)
                         when "operation_start_date"
                           cols << date_change(pre_row, col)
                         when "operation_finish_date"
                           cols << date_change(pre_row, col)
                         else
                           cols << pre_row.__send__("#{col}")
                         end
                       end
      result << cols
    end
    result.uniq!
    result.each do |r|
      r.shift
    end
    return result
  end

  def date_change(pre_row, column_name)
    if pre_row.__send__(column_name) =="" || pre_row.__send__(column_name) ==nil
      date =""
    else
      date =Date.parse(pre_row.__send__(column_name)).strftime("%Y/%m/%d")
    end
    return date
  end
end
