module ItemMethodChain
  module_function

  def resolve_method_chain(value, chain, polymorphic=false)
    if polymorphic
      if /\A([^#.]+)((?:\.[^#.]+#[^#.]+)*)\z/ !~ chain
        raise Item::Error, "invalid method_chain: #{chain.inspect}"
      end
      value = value.__send__($1)
      chain = $2.sub(/\A\./, '')
    else
      if /\A[^#.]+#[^#.]+(?:\.[^#.]+#[^#.]+)*\z/ !~ chain
        raise Item::Error, "invalid method_chain: #{chain.inspect}"
      end
    end
    value = value.to_i if value.is_a?(String) && /\A\d+\z/ =~ value
    chain.split('.').each do |s|
      return value if value.blank?
      unless value.is_a?(Integer)
        raise Item::Error, "invalid id: #{s} in #{chain.inspect}"
      end
      model_class_name, model_class_method = s.split('#')
      model_class = model_class_name.constantize
      value = model_class.find(value)
      return value if value.blank?
      value = value.__send__(model_class_method)
    end
    value
  end
end
