# -*- coding: utf-8 -*-
# 勘定科目を入力するための疑似項目。
# select タグを表示し、その選択肢はテーブル account_items から構成される。
class ItemPseudo::AccountItemSelect
  include ActionView::Helpers::TagHelper
  include ActionView::Helpers::FormTagHelper
  include ActionView::Helpers::FormOptionsHelper

  attr_accessor :item

  def initialize(item)
    @item = item
  end

  def to_data(it, &block)
    raise "ItemPseudo::AccountItemSelect: missing block" unless block_given?
    account_items = AccountItem.find(:all, :select => "id, code, name", :order => "code ASC")
    account_items.each {|a| a.name = "#{a.code}:#{a.name}"}
    selected = it.__send__(item.column_name).to_i
    select_tag("#{yield}[#{item.column_name}]", options_from_collection_for_select(account_items, 'id', 'name', selected), {:id => nil})
  end

  def set_attributes(x, attr)
    x.__send__("#{item.column_name}=", attr[item.column_name.to_sym])
  end
end
