desc 'Dump login histories to yaml fixtures'
namespace :db do
  namespace :fixtures do
    task :histdump => :environment do
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/data"

      ActiveRecord::Base.establish_connection(RAILS_ENV.to_sym)
      table_name = "login_histories"
      File.open("#{path}/#{table_name}.yml", 'wb') do |file|
        file.write ActiveRecord::Base.connection.select_all("SELECT * FROM #{table_name}").inject({}) { |hash, record|
          hash[record["id"]] = record
          hash
        }.to_yaml
      end
    end

    task :histload => :environment do
      require 'active_record/fixtures'
      ActiveRecord::Base.establish_connection(RAILS_ENV.to_sym)
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/data"
      Fixtures.create_fixtures(path, "login_histories")
    end
  end
end
