# -*- coding: utf-8 -*-
# app/controllers/business_card_controller.rb のクラス BusinessCardController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'business_card_controller'

# Re-raise errors caught by the controller.
class BusinessCardController; def rescue_action(e) raise e end; end

class BusinessCardControllerTest < ActionController::TestCase
  fixtures :business_card_companies, :business_card_branches, :business_cards

  # Replace this with your real tests.
  def setup
    @controller = BusinessCardController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
    @user = @request.session[:user_id]
    
    # set Branch LEFT JOIN Param
    @join_param = "LEFT JOIN business_card_branches on business_card_branches.company_id = business_card_companies.id"
    # ↑　:includeでは、count(distinct(`business_card_companies`.id))されるので、:joinsを使用
  end

  # BusinessCardController#index でリダイレクトされることをテストする。
  def test_index
    get :index
    assert_response :redirect
    assert_redirected_to :action => :test
  end

  # BusinessCardController#test がテンプレート 'test' を使って出力することをテストする。
  def test_test
    get :test
    assert_response :success
    assert_template "test"
    assert_select 'div#view_businesscard'
  end
  
  # BusinessCardController#company がパラメータ 'business_card_company' で成功することをテストする。
  def test_company
    get :company, :return_field => "company", :view => "view_main"
    assert_response :success
    assert_template "company"
    expected_count = PjcBusinessCardCompany.count
    assert_select "a.pick", :count => expected_count
  end

  # BusinessCardController#company に適切なパラメータが与えられた場合に
  # テンプレート 'company' による出力が行われることをテストする。
  def test_company_search_by_code
    get :company, :return_field => "company", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => "1_TEST"
    assert_response :success
    assert_template "company"
    expected_count = PjcBusinessCardCompany.count(:conditions => ["code like :code ESCAPE :ESCAPE", {:code => "%1^_TEST%", :ESCAPE => "^"}])
    assert_select "a.pick", :count => expected_count
  end

  # BusinessCardController#company に適切なパラメータが与えられた場合に
  # テンプレート 'company' による出力が行われることをテストする。
  def test_company_seach_by_name
    get :company, :return_field => "company", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => "2_TEST"
    assert_response :success
    assert_template "company"
    expected_count = PjcBusinessCardCompany.count(:conditions => ["name like ? ESCAPE ?", "%2^_TEST%", "^"])
    assert_select "a.pick", :count => expected_count
  end

  # BusinessCardController#company に適切なパラメータが与えられた場合に
  # テンプレート 'company' による出力が行われることをテストする。
  def test_company_search_by_none_code
    get :company, :return_field => "company", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => ""
    assert_response :success
    assert_template "company"
    expected_count = PjcBusinessCardCompany.count
    assert_select "a.pick", :count => expected_count
  end

  # BusinessCardController#company に適切なパラメータが与えられた場合に
  # テンプレート 'company' による出力が行われることをテストする。
  def test_company_search_by_none_name
    get :company, :return_field => "company", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => ""
    assert_response :success
    assert_template "company"
    expected_count = PjcBusinessCardCompany.count
    assert_select "a.pick", :count => expected_count
  end

  # BusinessCardController#company に適切なパラメータが与えられた場合に
  # テンプレート 'company' による出力が行われることをテストする。
  def test_company_not_found_search_by_code
    get :company, :return_field => "company", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => "Invalid_Keyword"
    assert_response :success
    assert_template "company"
    assert_select "a.pick", :count => 0
  end

  # BusinessCardController#company に適切なパラメータが与えられた場合に
  # テンプレート 'company' による出力が行われることをテストする。
  def test_company_not_found_search_by_name
    get :company, :return_field => "company", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => "Invalid_Keyword"
    assert_response :success
    assert_template "company"
    assert_select "a.pick", :count => 0
  end

  # BusinessCardController#branch がパラメータ 'business_card_branch' で成功することをテストする。
  def test_branch
    get :branch, :return_field => "branch", :view => "view_main"
    assert_response :success
    assert_template "branch"
    assert_select "table.picker_list"
    expected_count = PjcBusinessCardCompany.count(:joins => @join_param)
    assert_select "a.pick#?",/__company/, :count => expected_count
  end

  # BusinessCardController#branch に適切なパラメータが与えられた場合に
  # テンプレート 'branch' による出力が行われることをテストする。
  def test_branch_search_by_code
    get :branch, :return_field => "branch", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => "1_TEST"
    assert_response :success
    assert_template "branch"
    assert_select "table.picker_list"
    expected_count = PjcBusinessCardCompany.count(:joins => @join_param, :conditions => ["business_card_companies.code like ? ESCAPE ?", "%1^_TEST%", "^"])
    assert_select "a.pick#?",/__company/, :count => expected_count
  end

  # BusinessCardController#branch に適切なパラメータが与えられた場合に
  # テンプレート 'branch' による出力が行われることをテストする。
  def test_branch_seach_by_name
    get :branch, :return_field => "branch", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => "2_TEST"
    assert_response :success
    assert_template "branch"
    assert_select "table.picker_list"
    expected_count = PjcBusinessCardCompany.count(:joins => @join_param, :conditions => ["business_card_companies.name like ? ESCAPE ?", "%2^_TEST%", "^"])
    assert_select "a.pick#?",/__company$/, :count => expected_count
  end

  # BusinessCardController#branch に適切なパラメータが与えられた場合に
  # テンプレート 'branch' による出力が行われることをテストする。
  def test_branch_search_by_none_code
    get :branch, :return_field => "branch", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => ""
    assert_response :success
    assert_template "branch"
    assert_select "table.picker_list"
    expected_count = PjcBusinessCardCompany.count(:joins => @join_param)
    assert_select "a.pick#?",/__company$/, :count => expected_count
  end

  # BusinessCardController#branch に適切なパラメータが与えられた場合に
  # テンプレート 'branch' による出力が行われることをテストする。
  def test_branch_search_by_none_name
    get :branch, :return_field => "branch", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => ""
    assert_response :success
    assert_template "branch"
    assert_select "table.picker_list"
    expected_count = PjcBusinessCardCompany.count(:joins => @join_param)
    assert_select "a.pick#?",/__company$/, :count => expected_count
  end

  # BusinessCardController#branch に適切なパラメータが与えられた場合に
  # テンプレート 'branch' による出力が行われることをテストする。
  def test_branch_not_found_search_by_code
    get :branch, :return_field => "branch", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => "Invalid_Keyword"
    assert_response :success
    assert_template "branch"
    assert_select "table.picker_list"
    assert_select "a.pick", :count => 0
  end

  # BusinessCardController#branch に適切なパラメータが与えられた場合に
  # テンプレート 'branch' による出力が行われることをテストする。
  def test_branch_not_found_search_by_name
    get :branch, :return_field => "branch", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => "Invalid_Keyword"
    assert_response :success
    assert_template "branch"
    assert_select "table.picker_list"
    assert_select "a.pick", :count => 0
  end

  # BusinessCardController#person がパラメータ 'person' で成功することをテストする。
  def test_person
    get :person, :return_field => "person", :view => "view_main"
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCardCompany.count
    assert_select "span[class=tree_icon tree_icon_close]", :count => expected_count
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_search_by_company_code
    get :person, :return_field => "person", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => "1_TEST"
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCardCompany.count(:conditions => ["code like ? ESCAPE ?", "%1^_TEST%", "^"])
    assert_select "span[class=tree_icon tree_icon_close]", :count => expected_count
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_seach_by_company_name
    get :person, :return_field => "person", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => "2_TEST"
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCardCompany.count(:conditions => ["name like ? ESCAPE ?", "%2^_TEST%", "^"])
    assert_select "span[class=tree_icon tree_icon_close]", :count => expected_count
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_search_by_none_company_code
    get :person, :return_field => "person", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => ""
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCardCompany.count
    assert_select "span[class=tree_icon tree_icon_close]", :count => expected_count
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_search_by_none_company_name
    get :person, :return_field => "person", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => ""
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCardCompany.count
    assert_select "span[class=tree_icon tree_icon_close]", :count => expected_count
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_not_found_search_by_company_code
    get :person, :return_field => "person", :pjc_business_card_company_type => "code", :pjc_business_card_company_key => "Invalid_Keyword"
    assert_response :success
    assert_template "person"
    assert_select "span[class=tree_icon tree_icon_close]", :count => 0
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_not_found_search_by_company_name
    get :person, :return_field => "person", :pjc_business_card_company_type => "name", :pjc_business_card_company_key => "Invalid_Keyword"
    assert_response :success
    assert_template "person"
    assert_select "span[class=tree_icon tree_icon_close]", :count => 0
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_seach_by_person_name
    get :person, :return_field => "person", :pjc_business_card_type => "name", :pjc_business_card_key => "2_TEST"
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCard.count(:conditions => ["name like ? ESCAPE ?", "%2^_TEST%", "^"])
    assert_select "a[class=pick]", :count => expected_count
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_search_by_none_person_name
    get :person, :return_field => "person", :pjc_business_card_type => "name", :pjc_business_card_key => ""
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCard.count(:conditions => ["name like ?", ""])
    assert_select "a[class=pick]", :count => expected_count
  end

  # BusinessCardController#person に適切なパラメータが与えられた場合に
  # テンプレート 'person' による出力が行われることをテストする。
  def test_person_not_found_search_by_person_name
    get :person, :return_field => "person", :pjc_business_card_type => "name", :pjc_business_card_key => "Invalid_Keyword"
    assert_response :success
    assert_template "person"
    assert_select "a[class=pick]", :count => 0
  end
  
  # BusinessCardController#person に company の情報（id）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_person_pick_company_with_person
    get :person, :pjc_business_card_company_id => 1, :return_field => "person", :return_to => "business_card_test"
    assert_response :success
    assert_template "person"
    expected_count = PjcBusinessCard.count(:conditions => ["company_id = :company_id", {:company_id => 1}])
    assert_select "a[class=pick]", :count => expected_count
  end

  # BusinessCardController#person に company の情報（id）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_person_pick_company_without_person
    get :person, :pjc_business_card_company_id => 2, :return_field => "person", :return_to => "business_card_test"
    assert_response :success
    assert_template "person"
    assert_select "a[class=pick]", :count => 0
  end

  # BusinessCardController#pick に不正なパラメータが与えられるとリダイレクトすることをテストする。
  def test_pick
    get :pick, :return_field => "invalid_param"
    assert_response :redirect
    assert_redirected_to BusinessCardController::BUSINESS_CARD_ERROR_RETURN_TO
  end

  # BusinessCardController#pick に 取得情報（company_name）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_company_name
    get :pick, :pjc_business_card_company_id => 1, :return_field => "company_name", :return_to => "business_card_test"
    assert_response :redirect
    assert_redirected_to :action => :test

    get :test
    assert_response :success
    assert_template "test"
    assert_select "#company_id[value=?]", "1"
    assert_select "#company_code[value=?]", ""
    assert_select "#company_name[value=?]", "1_TEST_COMPANY_NAME_1"
  end

  # BusinessCardController#pick に 取得情報（company）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_company_code_name_from_company
    get :pick, :pjc_business_card_company_id => 3, :return_field => "company", :return_to => "business_card_test"
    assert_response :redirect
    assert_redirected_to :action => :test

    get :test
    assert_response :success
    assert_template "test"
    assert_select "#company_id[value=?]", "3"
    assert_select "#company_code[value=?]", "2_TEST_COMPANY_CODE"
    assert_select "#company_name[value=?]", "2_TEST_COMPANY_NAME_1"
  end

 # BusinessCardController#pick に 取得情報（company）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_company_code_name_from_branch
    get :pick, :pjc_business_card_company_id => 1, :return_field => "company", :return_to => "business_card_test"
    assert_response :redirect
    assert_redirected_to :action => :test

    get :test
    assert_response :success
    assert_template "test"
    assert_select "#company_id[value=?]", "1"
    assert_select "#company_code[value=?]", "1_TEST_COMPANY_CODE"
    assert_select "#company_name[value=?]", "1_TEST_COMPANY_NAME_1"
  end

  # BusinessCardController#pick に 取得情報（branch,company）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_company_code_name_and_branch_code_name
    get :pick, :pjc_business_card_company_id => 1, :pjc_business_card_branch_id => 1, :return_field => "branch,company", :return_to => "business_card_test"
    assert_response :redirect
    assert_redirected_to :action => :test

    get :test
    assert_response :success
    assert_template "test"
    assert_select "#company_id[value=?]", "1"
    assert_select "#company_code[value=?]", "1_TEST_COMPANY_CODE"
    assert_select "#company_name[value=?]", "1_TEST_COMPANY_NAME_1"
    assert_select "#branch_id[value=?]", "1"
    assert_select "#branch_code[value=?]", "1-1_TEST_BRANCH_CODE"
    assert_select "#branch_name[value=?]", "1-1_TEST_BRANCH_NAME_1"
  end

 # BusinessCardController#pick に 取得情報（person）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_person_name_from_person
    get :pick, :pjc_business_card_company_id => 1, :pjc_business_card_id => 1, :return_field => "person", :return_to => "business_card_test"
    assert_response :redirect
    assert_redirected_to :action => :test

    get :test
    assert_response :success
    assert_template "test"
    assert_select "#person_id[value=?]", "1"
    assert_select "#person_name[value=?]", "1-1_TEST_PERSON_NAME"
  end

  # BusinessCardController#pick に 取得情報（person,company）がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_person_name_and_company_code_name
    get :pick, :pjc_business_card_company_id => 1, :pjc_business_card_id => 1, :return_field => "person,company", :return_to => "business_card_test"
    assert_response :redirect
    assert_redirected_to :action => :test

    get :test
    assert_response :success
    assert_template "test"
    assert_select "#person_id[value=?]", "1"
    assert_select "#person_name[value=?]", "1-1_TEST_PERSON_NAME"
    assert_select "#company_id[value=?]", "1"
    assert_select "#company_code[value=?]", "1_TEST_COMPANY_CODE"
    assert_select "#company_name[value=?]", "1_TEST_COMPANY_NAME_1"
  end
end
