# app/controllers/storage_object_controller.rb のクラス StorageObjectController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'storage_object_controller'

# Re-raise errors caught by the controller.
class StorageObjectController; def rescue_action(e) raise e end; end

class StorageObjectControllerTest < Test::Unit::TestCase
  def setup
    @controller = StorageObjectController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  # StorageObjectController#download に不適切なパラメータが与えられた場合に、
  # 404エラーを返すことをテストする。
  def test_download_404
    get "download"
    assert_response 404
  end

  # StorageObjectController#download に適切なパラメータが与えられた場合に、
  # 対応する content type とともに出力されることをテストする。
  def test_download_success
    path = Pathname.new(RAILS_ROOT) + "tmp/2"
    begin
      File.open(path.to_s, "w+") do |f|
        f.truncate(32)
        f.chmod(0644)
      end
    rescue SystemCallError
      # could be happened
      return
    end
    begin
      get "download", :id => 2
      assert_response :success
      assert_equal "text/plain", @response.content_type
    ensure
      File.unlink(path.to_s)
    end
  end
end
