# -*- coding: utf-8 -*-
# app/models/application_table.rb のクラス ApplicationTable をテストする。

require 'test_helper'

class ApplicationTableTest < ActiveSupport::TestCase
  fixtures :application_tables, :application_models, :table_columns, :belongs_tos

  # ApplicationTable#table_columns が該当するカラムの情報を返すことをテストする。
  def test_table_columns
    t = application_tables(:appointments)
    assert_kind_of Array, t.table_columns
    assert_equal [1,2,3,4,5,6,7], t.table_columns.map(&:id)
  end

  # 新規作成および削除の際に create_table および drop_table が適切に動作することをテストする。
  def test_create_and_destroy
    t = ApplicationTable.new
    t.domain_id = 1
    t.name = "abcedf"
    t.save!
    [[:x, :integer], [:y, :string], [:z, :boolean]].each do |n, k|
      c = TableColumn.new(:table_type => "ApplicationTable", :table_id => t.id)
      c.domain_id = 1
      c.name = n.to_s
      c.type = "TableColumn#{k.to_s.camelize}"
      c.save!
    end
    assert t.create_table
    assert t.destroy
  end
end
