# -*- coding: utf-8 -*-
require 'test_helper'

class ItemMethodCascadeTest < ActiveSupport::TestCase

  # 空文字列や nil に達した場合にはそのまま返す。
  def test_resolve_method_cascade__blank
    assert_equal "", ItemMethodCascade.resolve_method_cascade("", "abcd.efgh.ijkl")
    assert_nil ItemMethodCascade.resolve_method_cascade(nil, "abcd.efg")
    assert_equal "it", ItemMethodCascade.resolve_method_cascade("it", "")
  end

  # '.' を含まない文字列の場合はそのままメソッド呼び出しの結果を返す。
  def test_resolve_method_cascade__simple
    x = stub(:abc => "123")
    assert_equal "123", ItemMethodCascade.resolve_method_cascade(x, "abc")
  end

  # '.' を含む文字列の場合はカスケードする。
  def test_resolve_method_cascade__proper
    efg = stub(:hij => "hij")
    abc = stub(:efg => efg)
    x = stub(:abc => abc)
    assert_equal "hij", ItemMethodCascade.resolve_method_cascade(x, "abc.efg.hij")
  end
end
