# -*- coding: utf-8 -*-
require 'test_helper'

class ItemMethodChainTest < ActiveSupport::TestCase

  class Foo
    def self.find(id)
      return "foo_#{id}" if id < 100
      return nil
    end
  end

  class Bar
    def self.find(id)
      new(id)
    end

    attr_accessor :x

    def initialize(x)
      @x = x - 10
    end
  end

  # 空文字列や nil に達した場合にはそのまま返す。
  def test_resolve_method_chain__blank
    assert_equal "", ItemMethodChain.resolve_method_chain("", "ItemMethodChainTest::Foo#to_sym")
    assert_nil ItemMethodChain.resolve_method_chain(nil, "ItemMethodChainTest::Foo#to_sym")
    assert_nil ItemMethodChain.resolve_method_chain(100, "ItemMethodChainTest::Foo#to_sym")
  end

  # 1つだけの参照の場合
  def test_resolve_method_chain__1
    assert_equal :foo_1, ItemMethodChain.resolve_method_chain(1, "ItemMethodChainTest::Foo#to_sym")
  end

  # 2つ続く参照の場合
  def test_resolve_method_chain__2
    assert_equal :foo_2, ItemMethodChain.resolve_method_chain(12, "ItemMethodChainTest::Bar#x.ItemMethodChainTest::Foo#to_sym")
  end

  # polymorphic な参照の場合
  def test_resolve_method_chain__polymorphic
    assert_equal :foo_3, ItemMethodChain.resolve_method_chain(Bar.new(13), "x.ItemMethodChainTest::Foo#to_sym", true)
  end

end
