# -*- coding: utf-8 -*-
require 'test_helper'

class SearchHelperTest < ActiveSupport::TestCase
  fixtures :items, :search_conditions, :search_condition_items

  def setup
    @helper = Object.new
    %w[TagHelper FormHelper FormOptionsHelper FormTagHelper].each {|m| @helper.extend("ActionView::Helpers::#{m}".constantize)}
    %w[GetText ApplicationHelper].each {|m| @helper.extend(m.constantize)}
    @helper.extend(SearchHelper)
  end

  def teardown
  end

  # SearchHelper#select_box_condition_pattern が search_condition_item を引数に与えられた場合に
  # 適切な select box を返す。
  def test_select_box_condition_pattern__with_existing_item
    item = search_condition_items(:list8_1_name)
    assert_kind_of String, @helper.select_box_condition_pattern(item)
  end

  # SearchHelper#select_box_condition_pattern が引数無しで呼ばれる場合に
  # 適切な select box を返す。
  def test_select_box_condition_pattern__with_new_item
    item = SearchConditionItem.new
    assert_kind_of String, @helper.select_box_condition_pattern(item)
  end
end
