class ApplicationModelGenerator < Rails::Generator::NamedBase
  attr_accessor :table_name, :belongs_to_polymorphic_true, :belongs_to_polymorphic_false, :has_many_as_name_aru, :has_many_as_name_nai,:parent_method_name, :ary
  default_options :quiet => true

  def initialize(*runtime_args)
    super
    @table_name = @belongs_to_polymorphic_true = @belongs_to_polymorphic_false = @has_many_as_name_aru = @has_many_as_name_nai = @parent_method_name = @ary = nil
    args.each do |a|
      attr, value = a.split('~')
      if %w|table_name belongs_to_polymorphic_true belongs_to_polymorphic_false has_many_as_name_aru has_many_as_name_nai parent_method_name ary|.include?(attr) && !value.blank?
        instance_variable_set("@#{attr}", value)
      end
    end
  end

  def manifest
    record do |m|
      # Check for class naming collisions.
      m.class_collisions class_path, class_name, "#{class_name}Test"
     
      # Model, test, and fixture directories.
      m.directory File.join('app/models', class_path)
      m.directory File.join('test/unit', class_path)
      
      # Model class, unit test, and fixtures.
      m.template 'application_model.rb', File.join('app/models', class_path, "#{file_name}.rb"), :collision => :skip, :quiet => true
      m.template 'unit_test.rb',  File.join('test/unit', class_path, "#{file_name}_test.rb"), :collision => :skip, :quiet => true
    end
  end

  protected
    def banner
      "Usage: #{$0} generate ModelName [table_name:name1, parent_method_name:name2]"
    end

    def add_options!(opt)
      opt.separator ''
      opt.separator 'Options:'
    end
end
