# CustomPagination
require "pagination"
module ActionController
  module Pagination
    class Paginator
      def current_page=(page)
        if page.is_a? Page
          raise ArgumentError, 'Page/Paginator mismatch' unless
            page.paginator == self
        end
        page = page.to_i
        page = 1 if page.zero?
        if has_page_number?(page)
          @current_page_number = page
        elsif page < 1
          @current_page_number = 1
        else
          @current_page_number = last_page
        end
      end
    end
  end
end
