# -*- coding: utf-8 -*-
require 'date'

# カレンダーで日付を選択する。
class CalendarController < ApplicationController
  before_filter :set_view

  # allow registered return_to only because do not redirect to any url
  CALENDAR_RETURN_TO = {
    :workflow_log_per_person => {:controller => "workflow", :action => "log_per_person"},
    :workflow_log_per_issue  => {:controller => "workflow", :action => "log_per_issue"},
    :calendar_test => {:controller => "calendar", :action => "test"},
  }.with_indifferent_access
  CALENDAR_ERROR_RETURN_TO = "/"

  # <tt>test</tt> へリダイレクトする。
  def index
    redirect_to :action => :test
  end

  # カレンダーを表示する。
  def calendar
    @year = (params[:year] || flash[:year] || Time.now.year).to_i
    @month = (params[:month] || flash[:month] || Time.now.month).to_i
    unless Date.valid_date?(@year, @month, 1)
      @year = Time.now.year
      @month = Time.now.month
    end
    @this = Date.new(@year, @month, 1)

    if params[:previous_year]
      @this = (@this << 12) unless params[:previous_month]
    elsif params[:previous_month]
      @this = (@this << 1)
    elsif params[:next_month]
      @this = (@this >> 1)
    elsif params[:next_year]
      @this = (@this >> 12)
    end

    @year = @this.year
    @month = @this.month

    @prev_month = (@this << 1)
    @next_month = (@this >> 1)
    @prev_year = (@this << 12)
    @next_year = (@this >> 12)

    @holidays = Hash.new(nil)

    # ToDo: select only the holidays during the specified month
    Holiday.find(:all, :select => "day", :conditions => ["year = ? AND month = ?", @year, @month]).each do |holiday|
      @holidays[holiday.day] = true
    end

    @return_format = params[:return_format] ? params[:return_format] : "yyyy/mm/dd"
    @alert_holiday = params[:alert_holiday]

    pass_params
  end

  # カレンダーから選択する。
  def pick
    flash[:pick] = {
      :field => params[:return_field],
      :return_value => params[:return_value]
    }
    if [:picker, :return_to].trav(session).is_a?(Symbol)
      x_close_or_redirect_to return_to_url
      return
    end
    return_to_action = [:picker, :return_to, :action].trav(session) do |key|
      logger.warn("CalendarController#pick: #{key} does not set")
    end
    #if %w[ new edit ].include? return_to_action
    if /\A(?:list|new|edit)/ =~ return_to_action
      x_close_or_redirect_to return_to_url
    else
      redirect_to return_to_url
    end
  end

  # (試験用)
  def test
    @current_view = "view_main"
    @sub_view = "view_calendar"

    if [:pick, :return_value].trav(flash)
      @formatted_date = flash[:pick][:return_value]
    end
  end

  private

  def set_view
    if /\Aview_[a-z0-9]+\z/ =~ params[:view]
      @current_view = params[:view]
    else
      @current_view = 'view_calendar'
    end
    @return_to_url = return_to_url
  end

  def return_to_url
    if return_to = CALENDAR_RETURN_TO[params[:return_to]]
      return return_to
    elsif session[:calendar_return_to]
      return session[:calendar_return_to]
    elsif [:picker, :return_to].trav(session)
      session[:picker][:return_to]
    else
      return CALENDAR_ERROR_RETURN_TO
    end
  end

  def pass_params(*singulars)
    @pass_params_link = {}
    [
      :return_to,
      :return_field,
      :view,
    ].each do |key|
      @pass_params_link[key] = params[key] if params[key]
    end

    @pass_params_form = @pass_params_link.dup
    [
      :return_format,
      :alert_holiday,
    ].each do |key|
      @pass_params_form[key] = params[key] if params[key]
    end
  end
end
