# 格子状のレイアウトを行うためのセルを制御する。
class CellController < ApplicationController
  # セルの高さを定める。
  def set_height
    Cell.update params[:id], :height => params[:value]
    render :text => params[:value]
  end

  def add_content_text #:nodoc:
    b = params[:cell][:body]
    i = ContentText.create :body => b
    add_item i
    render :text => b
  end

  def add_content_image #:nodoc:
    s = params[:cell][:src]
    w = params[:cell][:width]
    h = params[:cell][:height]
    i = ContentImage.create :src => s, :width => w, :height => h
    add_item i
    render :text => "<img src='#{s}' width='#{w}' height='#{h}' />"
  end

  def add_input #:nodoc:
    t = params[:cell][:type]
    c = params[:cell][:code]
    n = params[:cell][:name]
    i = "input_#{t}".classify.constantize.create :code => c, :name => n
    add_item i
    render :text => "<input type='#{t}' name='#{n}' />"
  end

  private

  def add_item(item)
    Layer.create :cell_id => params[:id], :item_id => item.id
  end
end
