# -*- coding: utf-8 -*-
# 業務を制御する。
class Pick::ProjectSegmentController < ApplicationController
  include Picker::Controller
  include ProjectCollaboration::ProjectHelper::Controller

  before_filter :set_current_project_and_segment, :except => [:reset]

  # 業務選択による絞り込みを行う画面を表示する。
  def narrow
    prepare(params[params[:rfw][:project_id]] || session[:project_id])
  end

  # 業務選択による絞り込みを行う、業務を検索する。
  def narrow_segments
    prepare_segments
  end

  # 業務選択による絞り込みを保存する。
  def save
    destroy_default_narrowings

    case params["saved"]
    when /\Asegment_(\d+)\z/
      id = $1
      x = picker_model_class("ProjectSegment").find(id)

      narrowing = Narrowing.find(:first, :conditions => {:controller_path => controller_path, :action_name => "narrow"})
      c = {:user_id => User.current_id, :narrowing_id => narrowing.id}
      default_narrowing = DefaultNarrowing.find(:first, :conditions => c)
      default_narrowing ||= DefaultNarrowing.new(c)
      default_narrowing.narrowing_value = id
      default_narrowing.narrowing_text = x.to_text
      default_narrowing.save!

      data = {}
      data[:display_id] = params[:display_id]
      data[params[:rfw][:project_id]] = x.project_id
      data[params[:rfw][:project_segment_id]] = id
      data[:narrowing_text] = x.to_text
      display_narrowing = DisplayNarrowing.find(:first, :conditions => {:display_id => params[:display_id], :narrowing_id => narrowing.id})
      data[params[:rfw][:display_narrowing_id]] = display_narrowing.id if display_narrowing
    else
      session[:project_segment_id] = nil
      data = {
        :display_id                         => params[:display_id],
        :narrowing_text                     => '',
        params[:rfw][:display_narrowing_id] => '',
        params[:rfw][:project_segment_id]   => '',
      }
    end

    render :text => data.to_json
  end

  # 業務選択による絞り込みをリセットする。
  def reset
    destroy_default_narrowings
    session[:project_segment_id] = nil
    prepare(nil)
    render :action => "narrow"
  end

  # 業務を選択するための一覧を表示する。
  def search
    prepare(nil, params[params[:rfw][:project_segment_id]])
    expose_writable_only
  end

  # 業務を選択するため、プロジェクトに属する業務を表示する。
  def select_segments
    prepare_segments
    expose_writable_only
  end

end
