# -*- coding: utf-8 -*-
# フレームワーク選択の制御を行う:
# - 一覧画面


class PjcApplyingFrameworkToTaskController < ProductController  
#class PjcApplyingFrameworkToTasksController < ApplicationController

  def entry_info
    #segment_idの存在判断
    unless params[:applying_segment_id]
      render :update do |page|
        page.call("alert",s_("PjcApplyingFrameworkToTask|error_message|select a segment"))
      end
      return
    end
    #進捗情報で選択されたプロジェクトIDと業務IDを取得
    #session[:pjc_task_returns_info] = nil
    session[:pjc_task_returns_info] ||= {}
    if params[:return_display_id] && params[:return_product_id]
      session[:pjc_task_returns_info][:display_id] =  params[:return_display_id]
      session[:pjc_task_returns_info][:product_id] =  params[:return_product_id]
    end
    @return_menu_id =Menu.find(:first,:conditions =>["product_id =?",session[:pjc_task_returns_info][:product_id].to_i]).id
    @applying_project_id = params[:applying_project_id] 
    @applying_segment_id = params[:applying_segment_id] 
    @selected_framework_logging_result = "1"
    @recycling_schedule_value = "plan"
    @work_user_result = "0"
    @applying_schedules =[]
    
    #一覧表示の準備を行う
    view_in :m
    prepare_display_to_list

    return if use_picker
    
    if @applying_schedules.length == 0
      #通常の画面表示の処理
      @candidate_frameworks = create_candidate_frameworks_list(nil)
      @candidate_segments = create_candidate_segments_list(nil)
      
      @applying_schedules = create_applying_schedules

    else
      #ピッカーを利用した場合の処理
      @candidate_frameworks = create_candidate_frameworks_list(frameworks_conditions)
      @candidate_segments = create_candidate_segments_list(segments_conditions)
    end

    # 4月14日変更
    select_project =PjcProject.find(:first,:conditions =>["id =?",@applying_project_id])
    if select_project
      @select_project_name =select_project.name
    end
    select_segment =PjcProjectSegment.find(:first,:conditions =>["id =?",@applying_segment_id])
    if select_segment
      @select_segment_name =select_segment.name
    end
    render :partial => "entry_info" 
  end

  def candidate_frameworks_list
    #適用可能なフレームワーク情報                                       
    @candidate_frameworks = create_candidate_frameworks_list(frameworks_conditions)
    render :partial => "candidate_frameworks_list"  ,:locals => {:ctr_n => "PjcApplyingFrameworkToTask"}
  end

  def candidate_segments_list
    #既に適用した経緯があるプロジェクト業務の一覧
    @candidate_segments = create_candidate_segments_list(segments_conditions)
    render :partial => "candidate_segments_list"  ,:locals => {:ctr_n => "PjcApplyingFrameworkToTask"}
  end
  
  def selected_object_add_child
    #下位に新しいTreeを追加します。
    prepare_schedule   
    @applying_schedules = []
    if params[:root] == "1"
      #進捗情報が1件も存在しないとき
      add_new_schedules(params,Hash.new,0,0,0,0) 
    else
      #進捗情報が1件以上存在するとき
      row_no = params[:row_no]
      params[:applying_schedule][:length].to_i.times{|row|
        list_request = params["applying_schedule_#{row}".to_sym]

        add_applying_schedules(list_request)
        if row_no.to_i == row
          #挿入行が出現        
          add_new_schedules(params,list_request,list_request[:default_id],0,0,0)
        end
      }
    end
    @applying_schedules.each_with_index {|d , idx| instance_variable_set("@applying_schedule_#{idx}", d) }
    
    render :partial => "applying_schedule_list"  ,:locals => {:ctr_n => "PjcApplyingFrameworkToTask"}
  end
  
  def selected_object_add_left
    #同じ階層の前にTreeを追加します。
    prepare_schedule    
    @applying_schedules = []
    row_no = params[:row_no]
    params[:applying_schedule][:length].to_i.times{|row|
      list_request = params["applying_schedule_#{row}".to_sym]
      if row_no.to_i == row
        #挿入行が出現
        add_new_schedules(params,list_request,list_request[:default_parent_id],list_request[:id],0,-1)
      end
      #画面情報の復帰
      add_applying_schedules(list_request)

    }
    @applying_schedules.each_with_index {|d , idx| instance_variable_set("@applying_schedule_#{idx}", d) }
    
    render :partial => "applying_schedule_list"  ,:locals => {:ctr_n => "PjcApplyingFrameworkToTask"}    
  end
  
  def selected_object_add_right
    #同じ階層の後にTreeを追加します。
    prepare_schedule    
    @applying_schedules = []
    row_no = params[:row_no]
    row_task_level = 0
    add_request = nil
    incomplete_end = false
    params[:applying_schedule][:length].to_i.times{|row|
      list_request = params["applying_schedule_#{row}".to_sym]
      if incomplete_end
        if row_task_level == list_request[:task_level]
          add_new_schedules(params,add_request,list_request[:parent_id],0,list_request[:id],-1)
          row_task_level = 0
          incomplete_end = false
        end
      end
      #画面情報の復帰
      add_applying_schedules(list_request)
      if row_no.to_i == row
        #挿入行が出現
        unless params["applying_schedule_#{row + 1}".to_sym]
          #次の行が存在しないとき
          add_new_schedules(params,list_request,list_request[:default_parent_id],0,0,-1)
        else
          if list_request[:task_level] == params["applying_schedule_#{row + 1}".to_sym][:task_level]
            #次の行が同階層のとき
            add_new_schedules(params,list_request,list_request[:default_parent_id],0,0,-1)
          else
            row_task_level= list_request[:task_level]
            add_request = list_request
            incomplete_end = true
          end
        end 
      end
      #before_task_level = list_request[:task_level]
    }
    if incomplete_end
      add_new_schedules(params,add_request,add_request[:default_parent_id],0,0,-1)
    end
    @applying_schedules.each_with_index {|d , idx| instance_variable_set("@applying_schedule_#{idx}", d) }
    
    render :partial => "applying_schedule_list"  ,:locals => {:ctr_n => "PjcApplyingFrameworkToTask"}   
  end
  
  def change_applying_checked
    #適用
    prepare_schedule    
    @applying_schedules = []
    row_no = params[:row_no]
    checked_top_level = 999999999
    checked_value = ""
    params[:applying_schedule][:length].to_i.times{|row|
      list_request = params["applying_schedule_#{row}".to_sym]
      if row_no.to_i == row
        checked_top_level = list_request[:task_level].to_i
        checked_value = list_request[:applying_checked] == "true" ? "false" : "true"
        list_request[:applying_checked] = checked_value
      else
        if checked_top_level < list_request[:task_level].to_i
          list_request[:applying_checked] = checked_value
        elsif checked_top_level == list_request[:task_level].to_i
          checked_top_level = 999999999
        end
      end
      #画面情報の復帰
      add_applying_schedules(list_request)
    }
    @applying_schedules.each_with_index {|d , idx| instance_variable_set("@applying_schedule_#{idx}", d) }
    
    render :partial => "applying_schedule_list"  ,:locals => {:ctr_n => "PjcApplyingFrameworkToTask"}   
  end
  
  def applying
    #データを適用する。
    prepare_schedule
    #登録処理前の入力チェック
    display = @product.displays.find(:first,:conditions =>["type =?","DisplayToNew"])
    items = display.items.find(:all, :conditions => ["layout > 0"], :order => "layout,id")
    @task = @model_class.new
    @applying_schedules = []
    error = false
    params[:applying_schedule][:length].to_i.times{|row|
      list_request = params["applying_schedule_#{row}".to_sym]
      it = @model_class.new
      items.each {|i| i.set_attributes(it, list_request)}
      add_singleton_validations(it, items)    
      unless valid?(it)
        error = true
      end
      
      @applying_schedules << instance_variable_set("@applying_schedule_#{row}", return_applying_schedules(it,list_request))
    }
    if error
      #入力チェックでエラーが発生している場合。
      render :partial => "applying_schedule_list"  ,:locals => {:ctr_n => "PjcApplyingFrameworkToTask"}      

      return
    end

    begin
      ActiveRecord::Base::transaction() do
        #フレームワーク適用情報登録処理の開始
        @applying_framewrok_ids = @applying_framewrok_ids.split(/,/)
        @applying_framewrok_ids.each do |apply_framework_id|
          fw = PjcSegmentApplyFramework.find(
                 :first , 
                 :conditions=>{:project_id =>@applying_project_id ,
                               :segment_id =>@applying_segment_id ,
                               :apply_framework_id => apply_framework_id})
          unless fw
            fw = PjcSegmentApplyFramework.new
            fw.project_id = @applying_project_id
            fw.segment_id = @applying_segment_id
            fw.apply_framework_id = apply_framework_id
            fw.apply_person_id = User.current_id
            fw.apply_date = Time.now.utc.strftime("%Y%m%d%H%M%S")
            fw.save!
          end
        end
        #タスク登録処理の開始
        framework_id_map = Hash.new()
        segment_task_id_map = Hash.new()
        task_lock_version_map = Hash.new()
        new_task_ids =[]
        params[:applying_schedule][:length].to_i.times{|row|
          list_request = params["applying_schedule_#{row}".to_sym]
          it = @model_class.new
          #新規登録行の処理
          if list_request[:id].to_i == 0 && list_request[:applying_checked] == "true"
            #登録プロジェクトの存在をチェックします。
            project_task = PjcApplyingFrameworkToTask.find_or_create_project(@applying_project_id)
            
            #登録するプロジェクト業務の存在をチェックし、存在しなければ作成しましう。       
            segment_task = PjcApplyingFrameworkToTask.find_or_create_segment(@applying_project_id,@applying_segment_id,project_task.id)
            
            #新規登録処理
            new_task = PjcTask.new( :project_id => @applying_project_id,
                                 :segment_id => @applying_segment_id,
                                 :task_level => list_request[:task_level].to_i,
                                 :task_weight => list_request[:task_weight],
                                 :code => list_request[:code],
                                 :name => list_request[:name],
                                 :planned_start_date => list_request[:planned_start_date].gsub("/","").gsub("-",""),
                                 :planned_finish_date => list_request[:planned_finish_date].gsub("/","").gsub("-",""),
                                 :person_in_charge_of_work_id => list_request[:person_in_charge_of_work_id])
            new_task.data_type = "task"
            if list_request[:default_tree] == "framework"
              new_task.framework_task_id = list_request[:default_id]
            end
            new_task.save!
            new_task_ids << new_task.id
            # タスク履歴登録処理(追加)
            PjcTaskRecord.create(:date_of_change =>Time.new.strftime("%Y/%m/%d"), :change_person_id => User.current.person_id,
                                :project_id => new_task.project_id, :segment_id => new_task.segment_id,
                                :task_id => new_task.id, :code => new_task.code,:name => new_task.name,
                                :planned_start_date => new_task.planned_start_date,:planned_finish_date => new_task.planned_finish_date,
                                :operation_start_date => new_task.operation_start_date, :operation_finish_date => new_task.operation_finish_date,
                                :task_weight => new_task.task_weight, :person_in_charge_of_work_id => new_task.person_in_charge_of_work_id)

            #新旧idの保存と上位タスクの新IDの取得
            new_parent_id = nil
            if list_request[:default_tree] == "framework"
              if framework_id_map[list_request[:default_id]] ==nil
                framework_id_map[list_request[:default_id]] = new_task.id
              end
              new_parent_id = framework_id_map[list_request[:default_parent_id]]
            else
              segment_task_id_map[list_request[:default_id]] = new_task.id
              new_parent_id = segment_task_id_map[list_request[:default_parent_id]]
            end

            #上位タスクの取得
            parent_task = nil
            if list_request[:default_parent_id].to_i > 0
              parent_task = PjcTask.find(:first ,:conditions=>{:id => new_parent_id , :data_type => "task" })
            else
              parent_task = PjcTask.find(:first ,:conditions=>{:id => list_request[:parent_id], :data_type => "task" })
              if parent_task
                parent_task.lock_version = task_lock_version_map[list_request[:parent_id]]
              end
            end
            
            if parent_task
              #上位がタスクの場合は排他制御を実施
              parent_task.save!            
            else
              parent_task = PjcTask.find(:first ,:conditions=>{:id => segment_task.id})
            end
            
            #タスクの上位移動
            parent_task.add_child(new_task)
            
            #タスクを前に追加する場合
            if list_request[:lft_id].to_i > 0
              new_task.move_to_left_of(PjcTask.find(list_request[:lft_id]))
            end
            
            #タスクを後に追加する場合
            if list_request[:rgt_id].to_i > 0
              new_task.move_to_right_of(PjcTask.find(list_request[:rgt_id]))
            end
            parent_task.task_weight = nil   #上位タスクを中間タスクに変更
            parent_task.save!
          elsif list_request[:id].to_i > 0
            task_lock_version_map[list_request[:id]] = list_request[:lock_version]
          end
        }
        # タスクの積上げ処理
        if new_task_ids !=[]
          new_task_ids.each do |new_task_id|
            task =PjcTask.find(new_task_id)
            if task && task.children ==[]
             # 自分の更新処理
              task.task_evm_total_create_children(task)
              task.task_evm_total_update_children(task)
             # 上位タスクの更新処理
              if task.parent
                task.new_rank_update(task.parent)
              elsif task.data_type =="segment"
                p =PjcTask.find(:first,:conditions =>{:project_id =>task.project_id,:data_type =>"project"})
                task.new_rank_update(p)
              end
            end
          end
        end
      end
      flash[:notice] = s_("rfw|flash|notice|It was successfully created.")
      @notice_result = "1"
    rescue ActiveRecord::StaleObjectError  
      @stale_object_error = true
    end
    session[:fw_task_add_id] = nil
    session[:task_add_id] = nil
    return_menu_id =Menu.find(:first,:conditions =>["product_id =?",session[:pjc_task_returns_info][:product_id].to_i]).id
    render :update do |page|
     page.call("onAjaxLink","link_m_#{return_menu_id}")
    end
    #return
  end
   
  private
 
  def create_applying_schedules
    @applying_schedules = @model_class.find(
                            :all,
                            :conditions => {:project_id => @applying_project_id , 
                                            :segment_id =>@applying_segment_id ,
                                            :data_type => "task" } ,
                            :order=>"tasks.lft")

    #初期値の設定等
    @applying_schedules.each_with_index {|d , idx| instance_variable_set("@applying_schedule_#{idx}", init_values(d)) }
    
    return @applying_schedules
  end
  
  def prepare_schedule
    params[:product_id] = params[:product][:id]
    @applying_project_id = params[:applying_schedule][:project_id]
    @applying_segment_id = params[:applying_schedule][:segment_id]
    @selected_framework_id = params[:selected_framework][:id]
    @selected_framework_logging_result = params[:selected_framework][:logging_result]
    @selected_project_segment_project_id = params[:selected_project_segment][:project_id] 
    @selected_project_segment_segment_id = params[:selected_project_segment][:segment_id]
    @recycling_schedule_value =  params[:selected_project_segment][:recycling_schedule]
    @work_user_result =  params[:selected_project_segment][:work_user_result] 
    @applying_framewrok_ids = params[:applying_framewrok][:ids]
    @applying_framewrok_ids = @applying_framewrok_ids.split(/,/)
    if @selected_framework_logging_result == "1"
      @applying_framewrok_ids << @selected_framework_id
      @applying_framewrok_ids.uniq!
    end
    @applying_framewrok_ids = @applying_framewrok_ids.join(",")
    #一覧表示の準備を行う
    view_in :m
    prepare_display_to_list

  end
 
  def cast(task)
    app_task = @model_class.new
    app_task.attributes = task.attributes
    return app_task
  end
  
  def init_values(task)
    task.default_id = task.id
    task.default_parent_id = task.parent_id
    task.task_level = task.task_level
    task.applying_checked = "true" 
    task.applying_disabled = "true"
    return task    
  end 
  
  def return_applying_schedules(it,data)                          
    it.id = data[:id]
    it.parent_id = data[:parent_id]
    it.default_id = data[:default_id]
    it.default_parent_id = data[:default_parent_id]
    it.lft_id = data[:lft_id]
    it.rgt_id = data[:rgt_id]
    it.default_tree = data[:default_tree]
    it.task_level = data[:task_level]
    it.task_weight = data[:task_weight]
    it.code = data[:code] 
    it.name = data[:name] 
    it.planned_start_date = data[:planned_start_date] 
    it.planned_finish_date = data[:planned_finish_date] 
    it.person_in_charge_of_work_id = data[:person_in_charge_of_work_id]
    it.applying_checked = data[:applying_checked] 
    it.applying_disabled = data[:applying_disabled]
    it.lock_version = data[:lock_version]
    return it
  end
 
  def frameworks_conditions
    conditions = nil
    if params[:framework_condition][:name] != ""
      conditions = ["frameworks.name like ?","%#{params[:framework_condition][:name]}%"]
    end
    return conditions
  end
  
  def segments_conditions
    conditions = []
    sql = nil
    cnd = []
    if params[:segment_search][:project_code]
      sql = "projects.code like ?"
      cnd << "%#{params[:segment_search][:project_code]}%"
    end    
    if params[:segment_search][:project_name]
      sql += sql ? " and projects.name like ?" : "projects.name like ?"
      cnd << "%#{params[:segment_search][:project_name]}%"
    end  
    if params[:segment_search][:segment_name]
      sql += sql ? " and project_segments.name like ?" : "segments.name like ?"
      cnd << "%#{params[:segment_search][:segment_name]}%"
    end  
    if params[:segment_search][:applying_framework_name]
      sql += sql ? " and frameworks.name like ?" : "frameworks.name like ?"
      cnd << "%#{params[:segment_search][:applying_framework_name]}%"
    end  
    conditions << sql 
    conditions += cnd    
  end 
  
  def add_applying_schedules(data)

    task =  PjcApplyingFrameworkToTask.new(
              :default_id => data[:default_id],
              :default_parent_id => data[:default_parent_id],
              :lft_id => data[:lft_id],
              :rgt_id => data[:rgt_id],
              :default_tree => data[:default_tree],
              :task_level => data[:task_level],
              :task_weight => data[:task_weight],
              :code => data[:code] ,
              :name => data[:name] ,
              :planned_start_date => data[:planned_start_date] ,
              :planned_finish_date => data[:planned_finish_date] ,
              :person_in_charge_of_work_id => data[:person_in_charge_of_work_id],
              :applying_checked => data[:applying_checked], 
              :applying_disabled => data[:applying_disabled],
              :lock_version => data[:lock_version])  
                          
    task.id = data[:id]
    task.parent_id = data[:parent_id]
    @applying_schedules << task
  end
  
  def add_new_schedules(id,data,parent_id,lft_id,rgt_id,correction)
      # frame_taskの行が100以内の場合
      if session[:fw_task_add_id]
        session[:fw_task_add_id] =(session[:fw_task_add_id].to_i + 100)
      else
        session[:fw_task_add_id] =100
      end
      if session[:task_add_id]
        session[:task_add_id] =(session[:task_add_id].to_i + 100)
      else
        session[:task_add_id] =100
      end
      unless id[:selected_framework][:id] == ""
      #フレームワークの追加
      @applying_schedules += PjcApplyingFrameworkToTask.framework_task_to_task(
                               id[:selected_framework][:id],
                               parent_id,
                               lft_id,
                               rgt_id,
                               data[:task_level].to_i + correction.to_i,
                               session[:fw_task_add_id])
    else
      #進捗情報の追加
      @applying_schedules += PjcApplyingFrameworkToTask.segment_task_to_task(
                               id[:selected_project_segment][:segment_id],
                               parent_id,
                               lft_id,
                               rgt_id,
                               data[:task_level].to_i + correction.to_i,
                               id[:selected_project_segment][:recycling_schedule],
                               id[:selected_project_segment][:work_user_result],
                               session[:task_add_id])
    end  
  end
  
  
  def create_candidate_frameworks_list(conditions)
    if conditions
      return PjcFramework.find(:all,
                               :conditions => conditions,
                               :joins => "join framework_tasks on framework_id = frameworks.id ",
                               :group => "framework_tasks.framework_id",
                               :order => "code") 
    else
      return PjcFramework.find(:all,
                               :joins => "join framework_tasks on framework_id = frameworks.id ",
                               :group => "framework_tasks.framework_id",
                               :order => "code") 
    end
  end
  
  def create_candidate_segments_list(conditions)
    if conditions
      return PjcSegmentApplyFramework.find( :all,
                                            :include => ["project","segment","apply_framework"] ,
                                            :conditions => conditions,
                                            :group => "segment_apply_frameworks.segment_id",
                                            :order => "projects.code,project_segments.code")
    else
      return PjcSegmentApplyFramework.find( :all,
                                            :include => ["project","segment","apply_framework"] ,
                                            :group => "segment_apply_frameworks.segment_id",
                                            :order => "projects.code,project_segments.code")
    end    
  end
  
  def use_picker
    session[:picker] ||= {}
    picker_session = session[:picker]
    if picker_session[:it_before_picker] &&
        picker_session[:it_applying_schedule] &&
        picker_session[:return_to] &&
        picker_session[:return_to][:controller] == params[:controller] &&
        picker_session[:return_to][:product_id] == params[:product_id] &&
        picker_session[:return_to][:action] == params[:action] &&
        picker_session[:return_to][:id] == params[:id]
      
      picker_session[:it_applying_schedule][:length].to_i.times{|row|
        @applying_schedules << instance_variable_set("@applying_schedule_#{row}", return_applying_schedules(@model_class.new,picker_session["applying_schedule_#{row}".to_sym]))
      } 
      @applying_project_id = picker_session[:it_applying_schedule][:project_id]
      @applying_segment_id = picker_session[:it_applying_schedule][:segment_id]
      @selected_framework_id = picker_session[:it_selected_framework][:id]
      @selected_framework_logging_result = picker_session[:it_selected_framework][:logging_result]
      @selected_project_segment_project_id = picker_session[:it_selected_project_segment][:project_id] 
      @selected_project_segment_segment_id = picker_session[:it_selected_project_segment][:segment_id]
      @recycling_schedule_value =  picker_session[:it_selected_project_segment][:recycling_schedule]
      @work_user_result =  picker_session[:it_selected_project_segment][:work_user_result] 
      @applying_framewrok_ids = picker_session[:it_applying_framewrok][:ids]
      @select_project_name = picker_session[:it_select_project_name]
      @select_segment_name  = picker_session[:it_select_segment_name] 
      @framework_condition_name = picker_session[:it_framework_condition][:name] 
      @segment_search_project_code  = picker_session[:it_segment_search][:project_code] 
      @segment_search_project_name  = picker_session[:it_segment_search][:project_name]
      @segment_search_segment_name  = picker_session[:it_segment_search][:segment_name]
      @segment_search_applying_framework_name  = picker_session[:it_segment_search][:applying_framework_name]
      @selected_framework_name = picker_session[:it_selected_framework][:name]
      @selected_project_segment_projcet_name = picker_session[:it_selected_project_segment][:projcet_name]
      @selected_project_segment_segment_name = picker_session[:it_selected_project_segment][:segment_name]
      
      params[:product_id] = picker_session[:it_product_id]
      params[:framework_condition] = {}
      params[:segment_search] = {}
      params[:framework_condition][:name] = picker_session[:it_framework_condition][:name]
      params[:segment_search][:applying_framework_name] = picker_session[:it_framework_condition][:applying_framework_name]
      params[:segment_search][:segment_name] = picker_session[:it_segment_search][:segment_name]
      params[:segment_search][:project_name] = picker_session[:it_segment_search][:project_name]
      params[:segment_search][:project_code] = picker_session[:it_segment_search][:project_code]
      session[:picker] = nil
    elsif params[:picker]
      picker, = params[:picker].keys
      if /\A(?:mail|(company|organization|person|post|group|calendar|lump)(\d+)(?:_(?:new_)?applying_schedule_\d+)?)\z/ =~ picker
        field = $1 || "mail"
        #item_id = $2
        if "calendar" == field
          flash[:year], flash[:month] = $1, $2
        end
        params[:applying_schedule][:length].to_i.times{|row|
          picker_session["applying_schedule_#{row}".to_sym] = params["applying_schedule_#{row}".to_sym]
        }     
        picker_session[:it_product_id] = params[:product][:id]
        picker_session[:it_applying_schedule] = params[:applying_schedule]
        picker_session[:it_selected_framework] = params[:selected_framework]
        picker_session[:it_selected_project_segment] = params[:selected_project_segment]
        picker_session[:it_applying_framewrok] = params[:applying_framewrok]
        picker_session[:it_select_project_name] = params[:select_project_name]
        picker_session[:it_select_segment_name] = params[:select_segment_name]
        picker_session[:it_framework_condition]  = params[:framework_condition]
        picker_session[:it_segment_search]  = params[:segment_search]
        picker_session[:it_selected_framework]  = params[:selected_framework]
        picker_session[:it_selected_project_segment]  = params[:selected_project_segment]
        picker_session[:it_before_picker] = params[:it] || {}
        picker_session[:return_to] = {
          :controller => params[:controller],
          :product_id => params[:product_id],
          :action     => params[:action],
          :id         => params[:id],
        }

        x_redirect_to @sub_view, picker, {
          :controller   => "picker",
          :action       => field,
          :return_field => field,
        }
        return true
      end
    end
    return false
  end
  
end
