# -*- coding: utf-8 -*-
require 'date'

module CalendarHelper
  # カレンダーを返す。
  def calendar(id, options = {}, &block)
    raise(ArgumentError, "No year given")  unless options.has_key?(:year)
    raise(ArgumentError, "No month given") unless options.has_key?(:month)

    block = Proc.new {|d| nil} unless block

    defaults = {
      :table_class => 'calendar',
      :day_name_class => 'dayName',
      :normal_day_class => 'normalDay',
      :holiday_class => 'holiday',
      :empty_day_class => 'emptyDay'
    }
    options = defaults.merge options

    day_names = [s_("rfw|Calendar|Sun"), s_("rfw|Calendar|Mon"), s_("rfw|Calendar|Tue"), s_("rfw|Calendar|Wed"), s_("rfw|Calendar|Thu"), s_("rfw|Calendar|Fri"), s_("rfw|Calendar|Sat")]

    cal = "<table id=\"#{id}\" class=\"#{options[:table_class]}\" border=\"0\">\n"

    # week names
    cal << "<thead>\n"
    cal << "<tr>\n"
    day_names.each{ |day_name|
      cal << "<th class=\"#{options[:day_name_class]}\">#{day_name}</th>\n"
    }
    cal << "</tr>\n"
    cal << "</thead>\n"

    # days
    cal << "<tbody>\n"
    day = Date.civil(@year, @month, 1)

    cal << "<tr>\n"
    day.wday.times{
      cal << "<td class=\"#{options[:empty_day_class]}\"></td>\n"
    }

    while day.month == @month
      if day.wday == 0 && day.mday != 1
        cal << "<tr>\n"
      end

      if block_given?
        cell_text, cell_attrs = block.call(day)
        day_class =
          cell_attrs.kind_of?(Hash) && cell_attrs[:class] ? cell_attrs[:class] : options[:normal_day_class]
        day_text = cell_text ? cell_text : day.mday.to_s
      else
        day_class = options[:normal_day_class]
        day_class = options[:holiday_class] if day.wday == 0 || day.wday == 6
        day_text = day.mday.to_s
      end
        cal << "<td class=\"#{day_class}\">#{day_text}</td>\n"

      if day.wday == 6
        cal << "</tr>\n"
      end

      day += 1
    end

    if day.wday != 0
      (7 - day.wday).times{
        cal << "<td class=\"#{options[:empty_day_class]}\"></td>\n"
      }
      cal << "</tr>\n"
    end

    cal << "</tbody>\n"

    cal << "</table>\n"
  end

  # 日付を選択するためのリンクを返す。
  def date_link(date, return_format, current_view, options, html_options = {})
    link_to_view_motion(date.mday.to_s,
                        current_view,
                        "calendar_#{date.mday.to_s}",
                        {},
                        options.merge(:action => "pick",
                                      :return_value => CustomFormatTranslator::format_date(date, return_format)),
                        html_options)
  end

  # 年を選択するための select box を返す。
  def year_selector(id, current_year)
    options = Array.new
    ((current_year-2)..(current_year+2)).each{ |year|
      options << [year.to_s, year.to_s]
    }
    select_tag(id,
               options_for_select(options, current_year.to_s),
               :id => nil,
               :class => "calendar_year",
               :onchange => "this.form.onsubmit()")
  end

  # 月の選択するための select box を返す。
  def month_selector(id, current_month)
    options = Array.new
    (1..12).each{ |month|
      options << [month.to_s, month.to_s]
    }
    select_tag(id,
               options_for_select(options, current_month.to_s),
               :id => nil,
               :class => "calendar_month",
               :onchange => "this.form.onsubmit()")
  end

  # カレンダーに配置する button box を返す。
  def calendar_button_box
    @calendar_button_box ||= lcr_button_box({
        :left => link_to_close({"_" => "&suffix;"}, @return_to_url, :class => "button"),
        :center => link_to_view_motion(s_("rfw|button|Clear"),
          @current_view, "clear", {"_"=>"&suffix;"},
          @pass_params_link.merge({:action => "pick", :return_value => ""}), :class => "button"),
      }, "w_lcr_button_box_half")
    return @calendar_button_box
  end
end
