# 一覧の設定画面の helper を与える。
module ListHelper

  def hidden_link_to_list
    link_to_view_motion(h(s_("rfw|List")), "view_list", @product.id,
                        {},
                        {:controller => "list", :action => "index", :id => @product.id},
                        {:class => "reloadable_link", :style => "display:none;"})
  end

  def link_to_add
    link_to_remote(h(s_("rfw|List|Add")), {
                     :update => "view_list",
                     :complete => visual_effect(:highlight, "list_list"),
                     :url => {:action => "add", :id => @product.id},
                   }, {
                     :class => "button"
                   })
  end

  def link_to_edit(display_id)
    #link_to_view_motion(h(s_("rfw|List|Edit")), @sub_view, display_id,
    link_to_view_motion('<img src="/images/memo.png" width=16 height=14 class="iepngfix" alt="' + h(s_("rfw|List|Edit")) + '"/>', @sub_view, display_id,
                        {},
                        {:action => "edit", :id => @product.id, :display_id => display_id},
                        {:class => "reloadable_link"})
  end

  def link_to_import
    link_to_view_motion(h(s_("rfw|List|Import")), @sub_view, "import",
                        {},
                        {:action => "import", :id => @product.id},
                        {:class => "button reloadable_link"})
  end

  def mode
    case @mode
    when :add
      mode = h(s_("rfw|List|Mode 'Add'"))
    when :edit
      mode = h(s_("rfw|List|Mode 'Edit'"))
    when :destroy
      mode = h(s_("rfw|List|Mode 'Destroy'"))
    else
      mode = false
    end
    return mode
  end

  def list_button_box(suffix)
    buttons = {
      :left   => link_to_close({"_" => suffix},
                               {:controller => "product", :id => @product.id, :action => "list"},
                               {:class => "button"}),
    }
    return lcr_button_box(buttons)
  end

  def detail_button_box(suffix)
    buttons = {
      :left   => link_to_close({"_" => suffix},
                               {:id => @product.id, :action => "index"},
                               {:class => "button"}),
      :center => submit_tag(h(s_("rfw|submit_tag|Update")), :class => "button", :name => "create"),
      :right => link_to_view_motion(h(s_("rfw|List|Destroy")), @current_view, "destroy",
                                    {"_" => "_#{suffix}"},
                                    {:action => "destroy", :id => @product.id, :display_id => @display.id},
                                    :confirm => s_("rfw|confirm|Are you sure?"),
                                    :method => :post,
                                    :class => "button"),
    }
    return lcr_button_box(buttons, "w_lcr_button_box_half")
  end

  def import_button_box(suffix)
    buttons = {
      :left   => link_to_close({"_" => suffix},
                               {:id => @product.id, :action => "index"},
                               {:class => "button"}),
    }
    return lcr_button_box(buttons)
  end

  def check_box_to_set_default
    return check_box_tag("set_default", "1", @display.default_list?)
  end

  def check_box_to_share
    return check_box_tag("share", "1", !@display.shared_lists.empty?)
  end

  def picker_to_share
    inputs = [{
                :type => 'text',
                :name => "roleable",
                :key => 'model_value',
                :html => {:readonly => true},
              }, {
                :type => 'hidden',
                :name => 'roleable_type',
                :key => 'model_name',
              }, {
                :type => 'hidden',
                :name => 'roleable_id',
                :key => 'model_id',
              },
             ]
    rfw_picker(inputs,
               {:controller => 'pick/lump', :action => 'search', :mode => 'company'},
               s_('rfw|submit_tag|Pick'))
  end

  def check_box_for_shared_list(shared_list)
    check_box_tag("shared_list[]", shared_list.id, true, :id => nil)
  end

  def input_display_sub
    text_field_tag("target[display_sub]", @target && @target[:display_sub])
  end

  def input_creator_sub
    text_field_tag("target[creator_sub]", @target && @target[:creator_sub])
  end

  def sortable_items
    x = ["selected", "unselected"]
    y = x.map {|prefix| "#{prefix}_items"}
    x.map do |prefix|
      sortable_element("#{prefix}_items",
                       :complete => visual_effect(:highlight, "#{prefix}_items"),
                       :url => {:action => "order_#{prefix}", :id => @product.id, :display_id => @display.id},
                       :dropOnEmpty => true,
                       :containment => y,
                       :constraint => false)
    end.join
  end
end
