# -*- coding: utf-8 -*-
module WorkflowHelper
  include PaginationConfiguration

  def header_line
    case params[:action]
    when 'pending_issues_list', 'accept_all'
      [
       s_('rfw|workflow|Detail'),
       s_('rfw|workflow|Document Name'),
       s_('rfw|workflow|Document Number'),
       s_('rfw|workflow|Issued At'),
       s_('rfw|workflow|Issuer Name'),
       s_('rfw|workflow|Lump Accept'),
       s_('rfw|workflow|Description'),
      ]
    when 'user_issues_list'
      [
       s_('rfw|workflow|Detail'),
       s_('rfw|workflow|Document Name'),
       s_('rfw|workflow|Document Number'),
       s_('rfw|workflow|Issued At'),
       s_('rfw|workflow|Authorizer Name'),
       s_('rfw|workflow|Flow Status'),
      ]
    when 'log_per_person'
      [
       s_('rfw|workflow|Issuer'),
       s_('rfw|workflow|Route'),
       s_('rfw|workflow|Document Number'),
       s_('rfw|workflow|Timestamp'),
       s_('rfw|workflow|Stage'),
       s_('rfw|workflow|Content'),
       s_('rfw|workflow|Person'),
      ]
    when 'log_per_issue'
      [
       s_('rfw|workflow|Route'),
       s_('rfw|workflow|Issuer'),
       s_('rfw|workflow|Document Number'),
       s_('rfw|workflow|Timestamp'),
       s_('rfw|workflow|Stage'),
       s_('rfw|workflow|Content'),
       s_('rfw|workflow|Person'),
      ]
    else
      raise "must not happen! action = #{params[:action]}"
    end.map{|label|
      content_tag(:th, label)
    }.join
  end

  def body_line(issue)
    case params[:action]
    when 'pending_issues_list', 'accept_all'
      [
       content_tag(:td, display_aspect('product', 'view_description', issue)),
       content_tag(:td, issue[0].issue_name),
       content_tag(:td, issue[0].message_body),
       content_tag(:td, issue[0].issued_at),
       content_tag(:td, issue[0].issuer_name),
       content_tag(:td){ check_box_tag('lump[]', issue[0].message_body, false, :id => "lump_#{issue[0].message_body}") },
       content_tag(:td, issue[0].issue_remark),
      ].join
    when 'user_issues_list'
      [
       content_tag(:td, display_aspect('product', 'view_description', issue)),
       content_tag(:td, issue[0].issue_name),
       content_tag(:td, issue[0].message_body),
       content_tag(:td, issue[0].issued_at),
       content_tag(:td, issue[0].authorizer_name),
       content_tag(:td, issue[0].description),
      ].join
    else
      raise "must not happen! action = #{params[:action]}"
    end
  end

  def route_options(routes)
    return nil if routes.blank?
    option_values = { s_('rfw|workflow|All Documents') => 'all__all' }
    routes.each do |r|
      option_values[r.name] = "#{r.workflow}__#{r.workflow_aux}"
    end
    options_for_select(option_values, params[:route])
  end

  def per_page_options
    option_values = ALLOWED_PER_PAGE.map{|n|
      if n == 0
        [s_("rfw|select|option|ALL"), n]
      else
        [(ns_("rfw|select|option|per %{n} page", "per %{n} pages", n) % {:n => n}), n]
      end
    }
    options_for_select(option_values, params[:per_page].blank? ? DEFAULT_PER_PAGE : params[:per_page].to_i)
  end

  # 詳細画面へのリンクを返す。
  # issue[0] : Workflow::IssueStatus
  # issue[1] : route に 対応する Product
  # issue[2] : 対応する実レコード (動的に決まる)
  def display_aspect(controller, view, issue)
    url = {
      :controller => controller,
      :action     => "show",
      :id         => issue[2].id,
      :type       => issue[2].class,
      :product_id => issue[1].id
    }
    @current_view = 'dummy'
    link = link_to_view_motion(image_tag("memo.png", :alt => _("Show")), view, "show",
                               { :id => issue[2].id }, url, :class => "reloadable_link")
  end

  def cptags(action, key)
    tags = text_field_tag key, params[key], :id => "#{action}_#{key}"
    tags << submit_tag(s_("rfw|submit_tag|Pick Date"), :name => "picker[#{key}]", :onclick => "$('#{action}_#{key}').addClassName('selected')")
    tags << link_to_view_motion("",
                                @sub_view, key, {},
                                { :controller => "calendar",
                                  :action => "calendar",
                                  :return_field => key,
                                  :return_format => "yyyy/mm/dd",
                                  :return_to => "workflow_#{action}".to_sym,
                                  :view => @sub_view,
                                }, :style => "display:none;")
    tags
  end

  def input_date_or_period(action)
    date   = (params[:date_or_period].to_i == 0)
    period = (params[:date_or_period].to_i != 0)
    b_date = radio_button_tag_with_label(:date_or_period, 0, s_("rfw|workflow|Date"), date, {
                                           :onclick => "$('#{action}_d').show();$('#{action}_period').hide();",
                                         })
    s_date = content_tag(:span, cptags(action, :date), {
                           :id => "#{action}_d",
                           :style => date ? nil : "display:none;",
                         })
    b_period = radio_button_tag_with_label(:date_or_period, 1, s_("rwf|workflow|Period"), period, {
                                             :onclick => "$('#{action}_d').hide();$('#{action}_period').show();",
                                           })
    s_period = content_tag(:span, [cptags(action, :inception), ' - ', cptags(action, :expiry)], {
                             :id => "#{action}_period",
                             :style => period ? nil : "display:none;",
                           })
    "#{b_date}&nbsp;#{s_date}<br />\n#{b_period}<br />#{s_period}"
  end

  def log_lines(*keys)
    lines, = @logs.inject([[], {}]) do |(result, prev), process|
      arr = []
      keys.each_with_index do |key, i|
        arr[i] = (process[key] == prev[key]) ? "" : process[key]
      end
      result << content_tag(:tr, arr.map {|x| content_tag(:td, x)}, :class => cycle('even', 'odd', :name => 'row_class'))
      [result, process]
    end
    lines
  end

end
