# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: config_output_items
#
#  id               :integer       not null, primary key
#  domain_id        :integer       not null
#  config_output_id :integer       not null
#  item_id          :integer       not null
#  enabled          :boolean
#  name             :string(255)
#  position         :integer
#  created_at       :string(14)
#  updated_at       :string(14)
#  created_by       :integer
#  updated_by       :integer
#  created_in       :integer
#  updated_in       :integer
#  lock_version     :integer       default(0), not null
#

# ファイル出力の対象になる項目のモデル。
class ConfigOutputItem < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :domain
  belongs_to :config_output
  acts_as_list :scope => :config_output
  belongs_to :item

  delegate :readable?, :selected?, :to_data, :link_url, :to => :item

  # 設定を初期化する。
  def clear(position)
    self.attributes = {
      :enabled  => true,
      :name     => item.name,
      :position => position,
    }
  end
end
