# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: organizations
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  company_id   :integer       not null
#  code         :string(255)   not null
#  name         :string(255)   not null
#  inception    :string(8)     not null
#  expiry       :string(8)     not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 組織のモデル。
class Organization < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_periodic
  belongs_to :domain
  belongs_to :company
  has_many :organization_members, :dependent => :destroy
  has_many :people, :through => :organization_members
  has_many :grant_ons, :as => :roleable, :dependent => :destroy

  validates_presence_of :company_id, :name, :code
  validates_associated :company

  date_column :inception, :expiry

  after_update :update_grant_ons

  # <em>p</em> と <em>q</em> が同じ組織の所属しているかどうか判定する。
  def self.exists_with_people?(p, q)
    return !((p.organizations & q.organizations).empty?)
  end

  # 名前および企業の名前を返す。
  def name_with_in
   "#{name} (#{company.name})"
  end

  private

  def update_grant_ons
    grant_ons.each do |grant_on|
      modified = false
      if grant_on.inception < attributes["inception"]
        grant_on.inception = attributes["inception"]
        modified = true
      end
      if attributes["expiry"] < grant_on.expiry
        grant_on.expiry = attributes["expiry"]
        modified = true
      end
      grant_on.save! if modified
    end
  end
end
