class CreatePermissions < ActiveRecord::Migration
  def self.up
    create_table :permissions do |t|
      t.column :grant_on_id, :int, :null => false
      t.column :user_id, :int, :null => false
      t.column :priority, :int, :null => false
      t.column :grant_target_id, :int, :null => false
      t.column :value, :string, :null => false
      t.column :inception, :string, :null => false, :limit => 8
      t.column :expiry, :string, :null => false, :limit => 8
    end
    add_index :permissions, :user_id
    add_index :permissions, :grant_target_id
  end

  def self.down
    remove_index :permissions, :grant_target_id rescue nil
    remove_index :permissions, :user_id rescue nil
    drop_table :permissions
  end
end
