# -*- coding: utf-8 -*-

require 'enumerator'

# Item の layout から、2列構成のテーブルを作る。
module ItemTableLayout
  # 詳細画面および編集画面で詳細情報を表示するための table を返す。
  #
  # itemsはlayoutが正のもののみで、layoutでソートされている必要がある。
  def to_table_layout(items, &block)
    h = Hash.new
    max = 0
    items.each do |item|
      n = item.layout.to_i
      item = block.call(item)
      max = n if max < n
      (h[n] ||= []) << item
    end
    table = []
    (1..max).each_slice(2) do |l, r|
      left, right = h[l], h[r]
      if left && right
        table << [left, right]
      else
        table << [left || right]
      end
    end
    return table
  end
end
