# <tt>Portlet</tt> インスタンスからの portlettable への委譲を実装する。
module PortlettableDelegator
  def self.included(base)
    base.class_eval do
      belongs_to :portlettable, :polymorphic => true
      include InstanceMethods
    end
  end

  module InstanceMethods
    def title
      [:title, :name].each do |name|
        return portlettable.__send__(name) if portlettable.respond_to?(name)
      end
    end

    def url_options
      portlettable.url_options
    end
  end
end
