# -*- coding: utf-8 -*-
require "active_record"

module ActiveRecord
  module ConnectionAdapters # :nodoc:
    module Quoting
      # SQL の LIKE 句を構成するデータをクオートする。
      def quote_like(s, escape)
        # FIXME: 商用RDBMSでは全角の「＿％」も考慮する必要あり。
        s.gsub(/[_%#{Regexp.quote(escape)}]/) do
          escape + $&
        end
      end
    end
  end
end
