# -*- coding: utf-8 -*-
# app/controllers/document_controller.rb のクラス DocumentController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'document_controller'

# Re-raise errors caught by the controller.
class DocumentController; def rescue_action(e) raise e end; end

class DocumentControllerTest < Test::Unit::TestCase
  fixtures(:domains, :matter_reports, :documents, :document_edges, :document_paths)

  def setup
    @controller = DocumentController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  # DocumentController#show に適切なパラメータが与えられた場合に
  # テンプレート 'show' による出力が行われることをテストする。
  def test_show
    get :show, :id => 1, :type => "Domain", :product_id => 8
    assert_response :success
    assert_template "show"
    assert_select "table"
  end

  # DocumentController#summary に適切なパラメータが与えられた場合に
  # テンプレート 'summary' による出力が行われることをテストする。
  def test_summary
    get :summary, :id => 1, :type => "Domain", :product_id => 8
    assert_response :success
    assert_template "summary"
    assert_select "div"
  end

  # DocumentController#edit に ID を含んだパラメータが与えられた場合に
  # テンプレート 'edit' による出力が行われることをテストする。
  def test_edit_with_id
    get :edit, :id => 1, :type => "Domain", :product_id => 8
    assert_response :success
    assert_template "edit"
    assert_select "div"
  end

  # DocumentController#edit に ID を含まないパラメータが与えられた場合に
  # テンプレート 'edit' による出力が行われることをテストする。
  def test_edit_without_id
    get :edit, :type => "Domain", :product_id => 8
    assert_response :success
    assert_template "edit"
    assert_select "div"
  end

  # DocumentController#cancel に適切なパラメータが与えられた場合に
  # テンプレート 'cancel' による出力が行われることをテストする。
  def test_cancel
    get :cancel, :id => 1, :type => "Domain", :product_id => 8
    assert_response :success
    assert_template "summary"
    assert_select "div"
  end

#   def test_delete
#     xhr :post, :delete, :id => 1, :type => "Domain", :product_id => 8
#     assert_response :success
#     assert_template "select"
#   end

  # DocumentController#toggle_mutual に適切なパラメータが与えられた場合に
  # テンプレート 'select' による出力が行われることをテストする。
  def test_toggle_mutual
    post :toggle_mutual, :id => 1, :type => "Domain", :product_id => 8
    assert_response :success
    assert_template "select"
    assert_select "div"
  end

  # DocumentController#select に適切なパラメータが与えられた場合に
  # テンプレート 'select' による出力が行われることをテストする。
  def test_select
    get :select, :id => 1, :type => "Domain", :product_id => 8, :target_id => 2, :target_type => "Domain", :target_product_id => 8
    assert_response :success
    assert_template "select"
    assert_select "div"
  end

  # DocumentController#select に ID を含まないパラメータが与えられた場合に
  # テンプレート 'select' による出力が行われることをテストする。
  def test_select__without_id
    get :select, :type => "Domain", :product_id => 8, :target_id => 3, :target_type => "Domain", :target_product_id => 8
    assert_response :success
    assert_template "select"
    assert_select "div"
  end

  # DocumentController#create に適切なパラメータが与えられた場合に
  # テンプレート 'create' による出力が行われることをテストする。
  def test_create
    get :create, :id => 1, :type => "Domain", :product_id => 8
    assert_response :success
    assert_template "create"
    assert_select "div"
  end

  # DocumentController#product に適切なパラメータが与えられた場合に
  # テンプレート 'product' による出力が行われることをテストする。
  def test_product
    xhr :post, :product, :id => 1, :type => "MatterReport", :product_id => 999
    assert_response :success
    assert_template "product"
    assert_select "select"
  end
end
