require "tmpdir"

module TemporaryFile
  def with_temporary_file(i, x, &block)
    path = File.join(RAILS_ROOT, 'tmp', i.to_s)
    begin
      File.open(path, "w+") {|f| f.write x} if x
      yield
    rescue SystemCallError
      # could be happened
    ensure
      begin
        File.unlink(path)
      rescue SystemCallError
      end
    end
  end
end
