# -*- coding: utf-8 -*-
# lib/acts_as_attachable.rb のモジュール ActiveRecord::Acts::Attachable をテストする。

require 'test_helper'

class ActsAsAttachableTest < ActiveSupport::TestCase
  fixtures :domains, :users, :attachments, :matters

  # 任意の model が acts_as_attachable を継承しているかどうかをテストする。
  def test_inherited
    [Domain, User, Attachment, Matter].each do |model_class|
      x = model_class.new
      assert x.respond_to?(:attachments)
      assert_equal [], x.attachments
    end
  end

  # メソッド attachements が動作することをテストする。
  def test_attachments
    matter = Matter.find(1)
    assert matter.attachments.is_a?(Array)
    assert_equal 2, matter.attachments.size
  end
end
