# -*- coding: utf-8 -*-
# app/models/mail_format.rb のクラス MailFormat をテストする。

require 'test_helper'

class MailFormatTest < ActiveSupport::TestCase
  fixtures :mail_formats, :domains, :people, :products, :companies, :posts

  # MailFormat#format_all がメールの設定情報を返すことをテストする。
  def test_format_all
    mail_format = MailFormat.find(1)
    product = Product.find(8)
    document = product.model_class.find(1)
    person = Person.find(1)
    mail = mail_format.format_all(product, document, person, person, "http://localhost:3000/", "no comment")
    mail.each do |key, value|
      assert_no_match /\0/, value, key
      assert_no_match /m=/, value, key
    end
  end
end
