require 'test_helper'

class NarrowingCondition::ProjectSegmentTest < ActiveSupport::TestCase
  fixtures :narrowings, :projects, :project_segments

  def test_text
    x = NarrowingCondition::ProjectSegment.new(narrowings(:project_narrow_s))
    assert_equal "project1 プロジェクト1 - 業務1", x.text(:project_segment_id => 1)
  end

  def test_condition
    narrowing = narrowings(:project_narrow_s)
    Narrowing.set_current(narrowing, :project_id, 1)
    Narrowing.set_current(narrowing, :project_segment_id, 1)
    x = NarrowingCondition::ProjectSegment.new(narrowing)
    assert_equal "foos.bar = #{::ProjectSegment.quote_value(1)}", x.condition("foos", "bar")
  end

end
