# -*- coding: utf-8 -*-
# lib/permission_observer.rb のクラス PermissionObserver をテストする。

require 'test_helper'

class PermissionObserverTest < ActiveSupport::TestCase
  fixtures :domains, :users, :grant_ons, :permissions, :products

  # GrantOn のレコードを変更した場合、それに属する Permission が期限に関わらず一旦削除される
  def test_after_update
    grant_on = GrantOn.find_with_period(1357)
    assert grant_on.update_attribute(:value, 'visible')
    assert_nil Permission.find_with_period(:first, :conditions => {:grant_on_id => 1357, :value => 'full'})
  end

  # GrantOn のレコードを削除した場合、それに属する Permission が期限に関わらず削除される
  def test_delete_all
    grant_on = GrantOn.find_with_period(1357)
    assert_difference('Permission.count_with_period', -1) do
      grant_on.destroy
    end
  end

end
