# -*- coding: utf-8 -*-
# app/models/po_translation.rb のクラス PoTranslation をテストする。

require 'test_helper'

class PoTranslationTest < ActiveSupport::TestCase
  fixtures :po_messages, :po_arguments, :po_translations

  # private_copy が個人利用のためのコピーを返す。
  def test_private_copy
    t = po_translations(:one)
    copy = t.private_copy(987654321)
    assert_kind_of PoTranslation, copy
    assert_equal t.msgstr, copy.msgstr
    assert (t.po_message_id != copy.po_message_id)
  end

  def test_to_po_string
    assert_equal <<PO_STRING, po_translations(:one).to_po_string
msgstr "こんにちは、世界!"
PO_STRING
    assert_equal <<PO_STRING, po_translations(:two).to_po_string
msgstr[0] "%{num} 個の項目があります。"
PO_STRING
  end

  def test_to_po_entry
    assert_equal <<PO_ENTRY, po_translations(:rfw_100001_ja).to_po_entry

#: PoTranslationJa:100001 PoMessagePlural:100001
msgid "1|rfw|Attachment|%{count} file attached"
msgid_plural "%{count} files attached"
msgstr[0] "%{count} ファイルが添付済"
PO_ENTRY

    assert_equal <<PO_ENTRY, po_translations(:rfw_100001_ja).to_po_entry(true)

#: PoTranslationJa:100001 PoMessagePlural:100001
msgid "rfw|Attachment|%{count} file attached"
msgid_plural "%{count} files attached"
msgstr[0] "%{count} ファイルが添付済"

msgid "1|rfw|Attachment|%{count} file attached"
msgid_plural "%{count} files attached"
msgstr[0] "%{count} ファイルが添付済"
PO_ENTRY
  end

end
