require 'test_helper'

class Rfw::GrantDataTest < ActiveSupport::TestCase

  fixtures :users, :grant_data_informations, :products, :displays, :items, :po_messages

  def setup
    CacheEachRequest.clear
    User.current = User.find(:first, :conditions => { :login => 'admin' })
    GrantDataInformation.create!(:target_product_id => 888, :target_display_id => 8884)
  end

  def teardown
    CacheEachRequest.clear
  end

  def test_create__without_login
    assert_raise(ArgumentError) do
      Rfw::GrantData.create('')
    end
  end

  def test_create__improper_login
    assert_raise(ArgumentError) do
      Rfw::GrantData.create('no such login')
    end
  end

  def test_create_and_drop
    CacheEachRequest.clear
    # delete existing fixtures at first
    DisplayToShow.delete_all
    DisplayToEdit.delete_all
    Item.delete_all
    assert_difference('ProductDetailedForGrantData.count', 4) do
      assert_difference('DisplayToShow.count', 4) do
        assert_difference('DisplayToEdit.count', 4) do
          assert_difference('ItemProper.count', 28) do
            assert_difference('ItemPseudo.count', 4) do
              Rfw::GrantData.create('admin')
            end
          end
        end
      end
    end
    CacheEachRequest.clear
    assert_difference('ProductDetailedForGrantData.count', -4) do
      assert_difference('DisplayToShow.count', -4) do
        assert_difference('DisplayToEdit.count', -4) do
            assert_difference('ItemProper.count', -28) do
              assert_difference('ItemPseudo.count', -4) do
                Rfw::GrantData.drop('admin')
              end
            end
        end
      end
    end
  end
end
