# -*- coding: utf-8 -*-
# app/models/search_condition.rb のクラス SearchCondition をテストする。

require 'test_helper'

class SearchConditionTest < ActiveSupport::TestCase
  fixtures(:displays, :items, :search_conditions, :search_condition_items)

  # SearchCondition#extract で出力される SQL 文をテストする。
  def test_extract
    quoted_table_name = Domain.quoted_table_name
    name = SearchCondition.quote_value('dummy%')
    code = SearchCondition.quote_value('DUMMY10050')
    assert_equal "(#{quoted_table_name}.name LIKE #{name}) AND (#{quoted_table_name}.code <= #{code})", search_conditions(:list8_1).extract
    assert !search_conditions(:list8_2).extract
  end
end
