# -*- coding: utf-8 -*-
# gettext による翻訳対象のカラムに関するモジュール。
module ActiveRecord
  module Acts #:nodoc:
    module Translated #:nodoc:
      def self.included(base)
        base.extend(ClassMethods)
      end

      module ClassMethods
        # あるモデルクラスでこの <tt>acts_as_translated</tt> を呼び出すと、
        # <em>options</em> に含まれる名前 <em>name</em> を持つメソッドが定義される。
        # このメソッドは <tt><em>name<em>_po<tt> というカラムに格納されている msgid の翻訳を値として返す。
        # また、<tt><em>name</em>=</tt> という代入用のメソッドも定義され、透過的に代入が可能になる。
        # 同時に、<tt><em>name</em>_(<em>code</em>)</tt> というメソッドも同時に定義され、
        # <em>code</em> に翻訳言語のコードを指定することもできる。
        def acts_as_translated(*options)
          configuration = {:prefix => ""}
          if options.last.is_a?(Hash)
            h = options.pop
            configuration.update(h)
          end
          p_ = configuration[:prefix].blank? ? "" : "#{configuration[:prefix].underscore}_"
          class_eval <<-EOV, __FILE__, __LINE__+1
            def po_translation_model_name
              "#{configuration[:prefix]}PoTranslation"
            end

            def po_language_model_name
              "#{configuration[:prefix]}Language"
            end
            include ActiveRecord::Acts::Translated::InstanceMethods
          EOV
          options.each do |name|
            class_eval <<-EOV, __FILE__, __LINE__+1
              belongs_to :#{name}_po_message, :class_name => "#{configuration[:prefix]}PoMessageSingular", :foreign_key => "#{name}_po"
              validates_presence_of :#{name}_po_message, :if => Proc.new {|x| x.#{name}_po != 0}
              #validates_presence_of :#{name}_en, :if => Proc.new {|x| x.#{name}_po != 0}

              def #{name}
                return @#{name} if defined?(@#{name})
                #{name}_po_message && #{name}_po_message.translation
              end

              def #{name}=(x)
                @#{name} = x
                #{configuration[:prefix]}Language.find(:all).each do |lang|
                  __send__("#{name}_\#{lang.code}=", x)
                end
              end

              def #{name}_(code)
                __send__("#{name}_\#{code}")
              end
            EOV
          end
        end
      end

      module InstanceMethods
        def translation(name, locale)
          type = "#{po_translation_model_name}#{locale.to_s.capitalize}".constantize
          po_message_id = attributes["#{name}_po"]
          type.find_or_initialize_by_po_message_id(po_message_id)
        end

        def method_missing(m, *args)
          if /(?:touch_)?(\w+)_(\w+)=?/ =~ m.to_s
            name, locale = $1, $2
            if "#{po_language_model_name}".constantize.exists? :code => locale
              self.class.__send__ :before_save, "touch_#{name}_#{locale}".to_sym
              self.class.class_eval <<-EOV, __FILE__, __LINE__+1
                def #{name}_#{locale}
                  @#{name}_#{locale} ||= translation("#{name}", "#{locale}")
                  @#{name}_#{locale}.msgstr
                end

                def #{name}_#{locale}=(msgstr)
                  return unless #{name}_po_message
                  @#{name}_#{locale} ||= translation("#{name}", "#{locale}")
                  return if @#{name}_#{locale}.msgstr == msgstr
                  @#{name}_#{locale}_modified = true
                  @#{name}_#{locale}.msgstr = msgstr
                end

                def touch_#{name}_#{locale}
                  if @#{name}_#{locale}_modified
                    @#{name}_#{locale}.save
                    #{name}_po_message.modified = true
                    #{name}_po_message.save
                  end
                  return true # assure invoking the next callback
                end
              EOV
              return __send__ m, *args
            end
          end
          super
        end
      end
    end
  end
end
