<?php {
/*
  $Id: checkout_shipping_address.php,v 1.1.9.1.2.16 2003/12/02 05:40:44 shota Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  require('../lib/catalog/application_top.php');

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $_SESSION['navigation']->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($_SESSION["cart"]->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

  // needs to be included earlier to set the success message in the messageStack
  require(DIR_FS_LANGUAGES . $_SESSION["language"] . '/' . FILENAME_CHECKOUT_SHIPPING_ADDRESS);

  require(DIR_FS_CLASSES . 'order.php');
  $order = new order;
  require(DIR_FS_CLASSES . 'address_form.php');
  $address_form = new addressForm;

// if the order contains only virtual products, forward the customer to the billing page as
// a shipping address is not needed
  if ($order->content_type == 'virtual') {
    if (!tep_session_is_registered('shipping')) tep_session_register('shipping');
    $_SESSION['shipping'] = false;
    if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
    $_SESSION['sendto'] = false;
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
  }

  $error = false;
  $process = false;
  if (isset($_POST['action']) && ($_POST['action'] == 'submit')) {
// ꤬̾äƤäƻ
    if (tep_not_null($_POST['firstname']) && tep_not_null($_POST['lastname']) && tep_not_null($_POST['street_address'])) {
      $process = true;

      if (ACCOUNT_GENDER == 'true') $gender = tep_db_prepare_input($_POST['gender']);
      if (ACCOUNT_COMPANY == 'true') $company = tep_db_prepare_input($_POST['company']);
      $firstname = tep_db_prepare_input($_POST['firstname']);
      $lastname = tep_db_prepare_input($_POST['lastname']);
      $street_address = tep_db_prepare_input($_POST['street_address']);
      if (ACCOUNT_SUBURB == 'true') $suburb = tep_db_prepare_input($_POST['suburb']);
      $postcode = tep_db_prepare_input($_POST['postcode']);
      $city = tep_db_prepare_input($_POST['city']);
      $country = tep_db_prepare_input($_POST['country']);
      if (ACCOUNT_STATE == 'true') {
        if (isset($_POST['zone_id'])) {
          $zone_id = tep_db_prepare_input($_POST['zone_id']);
        } else {
          $zone_id = false;
        }
        $state = tep_db_prepare_input($_POST['state']);
// 2003-06-06 add_telephone
		$telephone = tep_db_prepare_input($_POST['telephone']);
      }

      if (ACCOUNT_GENDER == 'true') {
        if ( ($gender != 'm') && ($gender != 'f') ) {
          $error = true;
          $messageStack->add('checkout_address', ENTRY_GENDER_ERROR);
        }
      }

      if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
        $error = true;
        $messageStack->add('checkout_address', ENTRY_FIRST_NAME_ERROR);
      }

      if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
        $error = true;
        $messageStack->add('checkout_address', ENTRY_LAST_NAME_ERROR);
      }

      if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
        $error = true;
        $messageStack->add('checkout_address', ENTRY_STREET_ADDRESS_ERROR);
      }

      if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
        $error = true;
        $messageStack->add('checkout_address', ENTRY_POST_CODE_ERROR);
      }

      if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
        $error = true;
        $messageStack->add('checkout_address', ENTRY_CITY_ERROR);
      }

	  // ƻܸϤDB˹ܤ¸ߤ뤫å 
      if (ACCOUNT_STATE == 'true') {
        $zone_id = 0;
        $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "'");
        $check = tep_db_fetch_array($check_query);
        $entry_state_has_zones = ($check['total'] > 0);
        if ($entry_state_has_zones == true) {
          $zone_query = tep_db_query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and (zone_name like '" . tep_db_input($state) . "%' or zone_code like '%" . tep_db_input($state) . "%')");
          if (tep_db_num_rows($zone_query) == 1) {
            $zone = tep_db_fetch_array($zone_query);
            $zone_id = $zone['zone_id'];
          } else {
            $error = true;

            $messageStack->add('checkout_address', ENTRY_STATE_ERROR_SELECT);
          }
        } else {
          if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
            $error = true;

            $messageStack->add('checkout_address', ENTRY_STATE_ERROR);
          }
        }
      }

      if ( (is_numeric($country) == false) || ($country < 1) ) {
        $error = true;

        $messageStack->add('checkout_address', ENTRY_COUNTRY_ERROR);
      }

// 2003-06-06 add_telephone
      if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
        $error = true;
      } else {
      }

      if ($error == false) {
        $next_id_query = tep_db_query("select max(address_book_id) as address_book_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $_SESSION["customer_id"] . "'");
        if (tep_db_num_rows($next_id_query)) {
          $next_id = tep_db_fetch_array($next_id_query);
          $entry_id = $next_id['address_book_id']+1;
        } else {
          $entry_id = 1;
        }

        $sql_data_array = array('customers_id' => $_SESSION["customer_id"],
                                'entry_firstname' => $firstname,
                                'entry_lastname' => $lastname,
                                'entry_street_address' => $street_address,
                                'entry_postcode' => $postcode,
                                'entry_city' => $city,
                                'entry_country_id' => $country,
                                'entry_telephone' => $telephone);

        if (ACCOUNT_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;
        if (ACCOUNT_COMPANY == 'true') $sql_data_array['entry_company'] = $company;
        if (ACCOUNT_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;
        if (ACCOUNT_STATE == 'true') {
          if ($zone_id > 0) {
            $sql_data_array['entry_zone_id'] = $zone_id;
            $sql_data_array['entry_state'] = '';
          } else {
            $sql_data_array['entry_zone_id'] = '0';
            $sql_data_array['entry_state'] = $state;
          }
        }

        if (!tep_session_is_registered('sendto')) tep_session_register('sendto');

        tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);

		//  Υɥ쥹ID򥻥å
        $_SESSION['sendto'] = tep_db_insert_id('address_book_id_seq');

        if (tep_session_is_registered('shipping')) tep_session_unregister('shipping');

        tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
      }
// process the selected shipping destination
    } elseif (isset($_POST['address'])) {
      $reset_shipping = false;
      if (tep_session_is_registered('sendto')) {
        if ($_SESSION['sendto'] != $_POST['address']) {
          if (tep_session_is_registered('shipping')) {
            $reset_shipping = true;
          }
        }
      } else {
        tep_session_register('sendto');
      }

      $_SESSION['sendto'] = $_POST['address'];

      $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $_SESSION['customer_id'] . "' and address_book_id = '" . $_SESSION['sendto'] . "'");
      $check_address = tep_db_fetch_array($check_address_query);

      if ($check_address['total'] == '1') {
        if ($reset_shipping == true) tep_session_unregister('shipping');
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
      } else {
        tep_session_unregister('sendto');
      }
    } else {
      if (!tep_session_is_registered('sendto')) tep_session_register('sendto');
      $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];

      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// if no shipping destination address was selected, use their own address as default
  if (!tep_session_is_registered('sendto')) {
    $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
  }

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL'));

  $addresses_count = tep_count_customer_address_book_entries();

  $tep_draw_form1 = tep_draw_form('checkout_address', tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL'), 'post', 'onSubmit="return check_form_optional(checkout_address);"');

  // $_POST['actino']=submit  firstname lastname streetaddress Τ $process = trueˤʤ
  if ($process == false) {
	$tep_address_label1 =  tep_address_label($_SESSION['customer_id'], $_SESSION['sendto'], true, ' ', '<br>');
   if ($addresses_count > 1) {
	 $addresses_query = tep_db_query("select address_book_id, entry_firstname as firstname, entry_lastname as lastname, entry_company as company, entry_street_address as street_address, entry_suburb as suburb, entry_city as city, entry_postcode as postcode, entry_state as state, entry_zone_id as zone_id, entry_country_id as country_id, entry_telephone as telephone from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$_SESSION["customer_id"] . "'");
	 $address_array = array();
      while ($addresses = tep_db_fetch_array($addresses_query)) {
        $format_id = tep_get_address_format_id($addresses['country_id']);
		$address_array[] = array('format_id' => $format_id, 'address_book_id' => $addresses['address_book_id'], 'tep_get_full_name' => tep_get_fullname2($addresses['firstname'],$addresses['lastname'],$addresses['country_id']), 'tep_draw_radio_field' => tep_draw_radio_field('address', $addresses['address_book_id'], ($addresses['address_book_id'] == $_SESSION['sendto'])), 'tep_address_format' => tep_address_format($format_id, $addresses, true, ' ', ', '));
      }
    }
  }
  if ($addresses_count < MAX_ADDRESS_BOOK_ENTRIES) {
	// ܿ
    if (isset($gender)) {
      $male = ($gender == 'm') ? true : false;
      $female = ($gender == 'f') ? true : false;
    } else {
      $male = false;
      $female = false;
    }
    $tep_draw_radio_field1 = tep_draw_radio_field('gender', 'm', $male);
	$tep_draw_radio_field2 = tep_draw_radio_field('gender', 'f', $female);
	$tep_draw_input_field1 = tep_draw_input_field('lastname');
	$tep_draw_input_field2 = tep_draw_input_field('firstname');
	$tep_draw_input_field3 = tep_draw_input_field('company');
    $tep_draw_input_field4 = tep_draw_input_field('street_address');
    $tep_draw_input_field5 = tep_draw_input_field('suburb');
    $tep_draw_input_field6 = tep_draw_input_field('postcode');
    $tep_draw_input_field7 = tep_draw_input_field('city');
	$tep_draw_input_field9 = tep_draw_input_field('telephone');

  if (ACCOUNT_STATE == 'true') {
        $tep_draw_input_field8 = tep_draw_input_field('state');
    if ($process == true) {
      if ($entry_state_has_zones == true) {
        $zones_array = array();
        $zones_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' order by zone_name");
        while ($zones_values = tep_db_fetch_array($zones_query)) {
          $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
        }
        $tep_draw_pull_down_menu1 = tep_draw_pull_down_menu('state', $zones_array);
      } else {
        $state = tep_get_zone_name($country, $zone_id, $state);
        $a_value = $state . tep_draw_hidden_field('zone_id') . tep_draw_hidden_field('state');
      }
  } else {
      $state = tep_get_zone_name($country, $zone_id, $state);
	  $address_form_inForm1 = $address_form->inForm('country');
      if ($address_form->inForm('country')) {
          $a_value = tep_draw_input_field('state', $state) . '&nbsp;' . ENTRY_STATE_TEXT;
      } else {
          $a_value = tep_get_zone_list('state', isset($country) ? $country : STORE_COUNTRY, $state) . '&nbsp;' . ENTRY_STATE_TEXT;
      }
  }
  $address_form->setFormLine('state',ENTRY_STATE,$a_value);

  // country
  if ($process == true) {
    if ($country_error == true) {
      $a_value = tep_get_country_list('country') . '&nbsp;' . ENTRY_COUNTRY_ERROR;
    } else {
      $a_value = tep_get_country_name($country) . tep_draw_hidden_field('country');
    }
  }
  }
  $tep_get_country_list1 = tep_get_country_list('country');
  }



  // old htmlpage was here
  $t->assign(array(
				   'address_form_inForm1' => $address_form_inForm1,
				   'address_array' => $address_array,
				   'country' => $country,
				   'country_error' => $country_error,
				   'entry_state_has_zones' => $entry_state_has_zones,
				   'zone_id' => $zone_id,
				   'state' => $state,
				   'process' => $process,
				   'request_type' => $request_type,
				   'tep_address_label1' => $tep_address_label1,
				   'tep_draw_form1' =>  $tep_draw_form1,
				   'tep_draw_radio_field1' => $tep_draw_radio_field1,
				   'tep_draw_radio_field2' => $tep_draw_radio_field2,
				   'tep_draw_input_field1' => $tep_draw_input_field1,
				   'tep_draw_input_field2' => $tep_draw_input_field2,
				   'tep_draw_input_field3' => $tep_draw_input_field3,
				   'tep_draw_input_field4' => $tep_draw_input_field4,
				   'tep_draw_input_field5' => $tep_draw_input_field5,
				   'tep_draw_input_field6' => $tep_draw_input_field6,
				   'tep_draw_input_field7' => $tep_draw_input_field7,
				   'tep_draw_input_field8' => $tep_draw_input_field8,
				   'tep_draw_input_field9' => $tep_draw_input_field9,
				   'tep_draw_pull_down_menu1' => $tep_draw_pull_down_menu,
				   'tep_get_country_list1' => $tep_get_country_list1,
				   'messageStack_size1' => $messageStack->size('checkout_address'),
				   'messageStack_output1' => $messageStack->output('checkout_address'),

));

  //$t->assign('body_template', 'checkout_shipping_address.html');
  tep_assign_template($t,'body_template', 'checkout_shipping_address.html');
  $t->display('layout.html');

}
?>
