--
-- PostgreSQL database dump
--

--
-- TOC entry 146 (OID 33799)
-- Name: if (boolean, numeric, numeric); Type: FUNCTION; Schema: public; Owner: tumf
--

CREATE FUNCTION if (boolean, numeric, numeric) RETURNS numeric
    AS '
   SELECT CASE WHEN $1 THEN $2 ELSE $3 END;
'
    LANGUAGE 'sql';


--
-- TOC entry 147 (OID 33800)
-- Name: to_days (timestamp with time zone); Type: FUNCTION; Schema: public; Owner: tumf
--

CREATE FUNCTION to_days (timestamp with time zone) RETURNS integer
    AS '
   SELECT EXTRACT(DAY FROM $1 - ''0000-01-01'')::integer
'
    LANGUAGE 'sql';


--
-- TOC entry 148 (OID 33801)
-- Name: dayofmonth (timestamp with time zone); Type: FUNCTION; Schema: public; Owner: tumf
--

CREATE FUNCTION dayofmonth (timestamp with time zone) RETURNS integer
    AS '
   SELECT EXTRACT(DAY FROM $1)::integer
'
    LANGUAGE 'sql';


--
-- TOC entry 149 (OID 33802)
-- Name: month (timestamp with time zone); Type: FUNCTION; Schema: public; Owner: tumf
--

CREATE FUNCTION "month" (timestamp with time zone) RETURNS integer
    AS '
   SELECT EXTRACT(MONTH FROM $1)::integer
'
    LANGUAGE 'sql';


--
-- TOC entry 150 (OID 33803)
-- Name: year (timestamp with time zone); Type: FUNCTION; Schema: public; Owner: tumf
--

CREATE FUNCTION "year" (timestamp with time zone) RETURNS integer
    AS '
   SELECT EXTRACT(YEAR FROM $1)::integer
'
    LANGUAGE 'sql';


--
-- TOC entry 151 (OID 33804)
-- Name: date_format (timestamp with time zone, "unknown"); Type: FUNCTION; Schema: public; Owner: tumf
--

CREATE FUNCTION date_format (timestamp with time zone, "unknown") RETURNS text
    AS '
   SELECT EXTRACT(YEAR FROM $1)::text 
   || (CASE WHEN EXTRACT(MONTH FROM $1) < 10 THEN ''0''::text || EXTRACT(MONTH FROM $1)::text ELSE EXTRACT(MONTH FROM $1)::text END) 
   || (CASE WHEN EXTRACT(DAY FROM $1) < 10 THEN ''0''::text || EXTRACT(DAY FROM $1)::text ELSE EXTRACT(DAY FROM $1)::text END)
'
    LANGUAGE 'sql';


--
-- TOC entry 152 (OID 33805)
-- Name: left (text, integer); Type: FUNCTION; Schema: public; Owner: tumf
--

CREATE FUNCTION "left" (text, integer) RETURNS text
    AS '
   SELECT SUBSTRING($1 FROM 0 FOR $2);
'
    LANGUAGE 'sql';


