<?php {
/*
  $Id: function.osc_tablebox.php,v 1.1.2.1 2003/11/12 12:57:36 kasugai Exp $
*/

  /* show module table
   * @param $table_border           int           table border
   * @param $table_width            int
   * @param $table_cellspacing      int
   * @param $table_parameters       string
   * @param $table_row_parameters   string
   * @param $table_data_parameters  string
   * @param $left_corner            bool          trim left corner
   * @param $right_corner           bool          trim right corner
   * @param $title                  string        module title
   * @param $contents               array         module contents
   * @param $table_paras            string        table option                              
   * @param $link                   string        link filename not url
   * @return string 
   */
  function smarty_function_osc_tableBox($params) {
	extract($params);
	if(empty($table_border))       $table_border = '0';
	if(empty($table_width))        $table_width = '100%';
	if(empty($table_cellspacing))  $table_cellspacing = '0';
	if(empty($table_cellpadding))  $table_cellpadding = '2';

      $tableBox_string = '<table border="' . tep_output_string($table_border) . '" width="' . tep_output_string($table_width) . '" cellspacing="' . tep_output_string($table_cellspacing) . '" cellpadding="' . tep_output_string($table_cellpadding) . '"';
      if (tep_not_null($table_parameters)) $tableBox_string .= ' ' . $table_parameters;
      $tableBox_string .= '>' . "\n";

      for ($i=0, $n=sizeof($contents); $i<$n; $i++) {
        if (isset($contents[$i]['form']) && tep_not_null($contents[$i]['form'])) $tableBox_string .= $contents[$i]['form'] . "\n";
        $tableBox_string .= '  <tr';
        if (tep_not_null($table_row_parameters)) $tableBox_string .= ' ' . $table_row_parameters;
        if (isset($contents[$i]['params']) && tep_not_null($contents[$i]['params'])) $tableBox_string .= ' ' . $contents[$i]['params'];
        $tableBox_string .= '>' . "\n";

        if (isset($contents[$i][0]) && is_array($contents[$i][0])) {
          for ($x=0, $n2=sizeof($contents[$i]); $x<$n2; $x++) {
            if (isset($contents[$i][$x]['text']) && tep_not_null($contents[$i][$x]['text'])) {
              $tableBox_string .= '    <td';
              if (isset($contents[$i][$x]['align']) && tep_not_null($contents[$i][$x]['align'])) $tableBox_string .= ' align="' . tep_output_string($contents[$i][$x]['align']) . '"';
              if (isset($contents[$i][$x]['params']) && tep_not_null($contents[$i][$x]['params'])) {
                $tableBox_string .= ' ' . $contents[$i][$x]['params'];
              } elseif (tep_not_null($table_data_parameters)) {
                $tableBox_string .= ' ' . $table_data_parameters;
              }
              $tableBox_string .= '>';
              if (isset($contents[$i][$x]['form']) && tep_not_null($contents[$i][$x]['form'])) $tableBox_string .= $contents[$i][$x]['form'];
              $tableBox_string .= $contents[$i][$x]['text'];
              if (isset($contents[$i][$x]['form']) && tep_not_null($contents[$i][$x]['form'])) $tableBox_string .= '</form>';
              $tableBox_string .= '</td>' . "\n";
            }
          }
        } else {
          $tableBox_string .= '    <td';
          if (isset($contents[$i]['align']) && tep_not_null($contents[$i]['align'])) $tableBox_string .= ' align="' . tep_output_string($contents[$i]['align']) . '"';
          if (isset($contents[$i]['params']) && tep_not_null($contents[$i]['params'])) {
            $tableBox_string .= ' ' . $contents[$i]['params'];
          } elseif (tep_not_null($table_data_parameters)) {
            $tableBox_string .= ' ' . $this->table_data_parameters;
          }
          $tableBox_string .= '>' . $contents[$i]['text'] . '</td>' . "\n";
        }
		
        $tableBox_string .= '  </tr>' . "\n";
        if (isset($contents[$i]['form']) && tep_not_null($contents[$i]['form'])) $tableBox_string .= '</form>' . "\n";
      }
	  
      $tableBox_string .= '</table>' . "\n";
      return $tableBox_string;
  }
}

?>