<?php {
/*
  $Id: account_edit.php,v 1.1.1.1 2004/01/07 09:18:18 shota Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  require('../lib/catalog/application_top.php');

  if (!tep_session_is_registered('customer_id')) {
    $_SESSION['navigation']->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// needs to be included earlier to set the success message in the messageStack
  require(DIR_FS_LANGUAGES . $_SESSION["language"] . '/' . FILENAME_ACCOUNT_EDIT);

  if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    if (ACCOUNT_GENDER == 'true') $gender = tep_db_prepare_input($_POST['gender']);
    $firstname = tep_db_prepare_input($_POST['firstname']);
    $lastname = tep_db_prepare_input($_POST['lastname']);
    if (ACCOUNT_DOB == 'true') $dob = tep_db_prepare_input($_POST['dob']);
    $email_address = tep_db_prepare_input($_POST['email_address']);
    $telephone = tep_db_prepare_input($_POST['telephone']);
    $fax = tep_db_prepare_input($_POST['fax']);

    $error = false;

    if (ACCOUNT_GENDER == 'true') {
      if ( ($gender != 'm') && ($gender != 'f') ) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_GENDER_ERROR);
      }
    }

    if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('account_edit', ENTRY_FIRST_NAME_ERROR);
    }

    if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('account_edit', ENTRY_LAST_NAME_ERROR);
    }

    if (ACCOUNT_DOB == 'true') {
      if (!checkdate(substr(tep_date_raw($dob), 4, 2), substr(tep_date_raw($dob), 6, 2), substr(tep_date_raw($dob), 0, 4))) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_DATE_OF_BIRTH_ERROR);
      }
    }

    if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
      $error = true;
      $messageStack->add('account_edit', ENTRY_EMAIL_ADDRESS_ERROR);
    }

    if (!tep_validate_email($email_address)) {
      $error = true;
      $messageStack->add('account_edit', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
    }

    $check_email_query = tep_db_query("select count(*) as total from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($email_address) . "' and customers_id != '" . (int)$_SESSION["customer_id"] . "'");
    $check_email = tep_db_fetch_array($check_email_query);
    if ($check_email['total'] > 0) {
      $error = true;
      $messageStack->add('account_edit', ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);
    }

    if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
      $error = true;
      $messageStack->add('account_edit', ENTRY_TELEPHONE_NUMBER_ERROR);
    }

    if ($error == false) {
      $sql_data_array = array('customers_firstname' => $firstname,
                              'customers_lastname' => $lastname,
                              'customers_email_address' => $email_address,
                              'customers_telephone' => $telephone,
                              'customers_fax' => $fax);
      if (ACCOUNT_GENDER == 'true') $sql_data_array['customers_gender'] = $gender;
      if (ACCOUNT_DOB == 'true') $sql_data_array['customers_dob'] = tep_date_raw($dob);

      tep_db_perform(TABLE_CUSTOMERS, $sql_data_array, 'update', "customers_id = '" . (int)$_SESSION["customer_id"] . "'");

      tep_db_query("update " . TABLE_CUSTOMERS_INFO . " set customers_info_date_account_last_modified = now() where customers_info_id = '" . (int)$_SESSION["customer_id"] . "'");

      $sql_data_array = array('entry_firstname' => $firstname,
                              'entry_lastname' => $lastname);

      tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array, 'update', "customers_id = '" . (int)$_SESSION["customer_id"] . "' and address_book_id = '" . (int)$_SESSION["customer_default_address_id"] . "'");

// reset the session variables
      $customer_first_name = $firstname;
      $messageStack->add_session('account', SUCCESS_ACCOUNT_UPDATED, 'success');

      tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
    }
  }

  $account_query = tep_db_query("select customers_gender, customers_firstname, customers_lastname, customers_dob, customers_email_address, customers_telephone, customers_fax from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$_SESSION["customer_id"] . "'");
  $account = tep_db_fetch_array($account_query);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL'));

  $tep_draw_form1 = tep_draw_form('account_edit', tep_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL'), 'post', 'onSubmit="return check_form(account_edit);"');
  $tep_draw_input_field1 = tep_draw_input_field('firstname', $account['customers_firstname']);
  $tep_draw_input_field2 = tep_draw_input_field('lastname', $account['customers_lastname']);
  $tep_draw_input_field4 = tep_draw_input_field('email_address', $account['customers_email_address']);
  $tep_draw_input_field5 = tep_draw_input_field('telephone', $account['customers_telephone']);
  $tep_draw_input_field6 = tep_draw_input_field('fax', $account['customers_fax']);

  // {*2*}
  if (ACCOUNT_GENDER == 'true') {
    if (isset($gender)) {
      $male = ($gender == 'm') ? true : false;
	  $account['mail'] = $male;
    } else {
      $male = ($account['customers_gender'] == 'm') ? true : false;
    }
    $female = !$male;
	$account['femail'] = $female;

	$tep_draw_radio_field1 = tep_draw_radio_field('gender', 'm', $male);
	$tep_draw_radio_field2 = tep_draw_radio_field('gender', 'f', $female);

  }

  //{*3*}
  if (ACCOUNT_DOB == 'true') {
    $tep_draw_input_field3 = tep_draw_input_field('dob', tep_date_short($account['customers_dob']));
  }

  // old htmlpage was here
  $t->assign_by_ref('messageStack', $messageStack);
  $t->assign(array(
				   'account' => $account,
				   'tep_draw_form1' =>  $tep_draw_form1,
				   'tep_draw_input_field1' => $tep_draw_input_field1,
				   'tep_draw_input_field2' => $tep_draw_input_field2,
				   'tep_draw_input_field3' => $tep_draw_input_field3,
				   'tep_draw_input_field4' => $tep_draw_input_field4,
				   'tep_draw_input_field5' => $tep_draw_input_field5,
				   'tep_draw_input_field6' => $tep_draw_input_field6,
				   'tep_draw_radio_field1' => $tep_draw_radio_field1,
				   'tep_draw_radio_field2' => $tep_draw_radio_field2,
));
  
  tep_assign_template($t,'body_template', 'account_edit.html');
  $t->display('layout.html');
}
?>
