<?php {
/*
  $Id: checkout_confirmation.php,v 1.1.1.1 2004/01/07 09:18:18 shota Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  require('../lib/catalog/application_top.php');

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $_SESSION["navigation"]->set_snapshot(array('mode' => 'SSL', 'page' => FILENAME_CHECKOUT_PAYMENT));
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($_SESSION['cart']->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($_SESSION["cart"]->cartID) && tep_session_is_registered('cartID')) {
    if ($_SESSION['cart']->cartID != $_SESSION['cartID']) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping')) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }

  if (!tep_session_is_registered('payment')) tep_session_register('payment');
  if (isset($_POST['payment'])) $_SESSION['payment'] = $_POST['payment'];

  if (!tep_session_is_registered('comments')) tep_session_register('comments');

  $_SESSION['comments'] = "";
  if (tep_not_null($_POST['comments'])) {
    $_SESSION['comments'] = tep_db_prepare_input($_POST['comments']);
  }

// load the selected payment module
  require(DIR_FS_CLASSES . 'payment.php');
  $payment_modules = new payment($_SESSION['payment']);

  require(DIR_FS_CLASSES . 'order.php');
  $order = new order;

  $payment_modules->update_status();

  if ( ( is_array($payment_modules->modules) && (sizeof($payment_modules->modules) > 1) && !is_object($$_SESSION['payment']) ) || (is_object($$_SESSION['payment']) && ($$_SESSION['payment']->enabled == false)) ) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
  }

  if (is_array($payment_modules->modules)) {
    $payment_modules->pre_confirmation_check();
  }

// load the selected shipping module
  require(DIR_FS_CLASSES . 'shipping.php');
  $shipping_modules = new shipping($_SESSION['shipping']);

  require(DIR_FS_CLASSES . 'order_total.php');
  $order_total_modules = new order_total;

// Stock Check
  $any_out_of_stock = false;
  if (STOCK_CHECK == 'true') {
    for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
      if (tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty'])) {
        $any_out_of_stock = true;
      }
    }
    // Out of Stock
    if ( (STOCK_ALLOW_CHECKOUT != 'true') && ($any_out_of_stock == true) ) {
      tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
    }
  }

  require(DIR_FS_LANGUAGES . $_SESSION["language"] . '/' . FILENAME_CHECKOUT_CONFIRMATION);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2);


  if ($_SESSION['sendto'] != false) {
	$tep_address_format1 = tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br>');

    if ($order->info['shipping_method']) {
     }
  }

  $sizeof1 = sizeof($order->info['tax_groups']);

  //{*2*}
  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
    if (STOCK_CHECK == 'true') {
      $oder->products[$i]['tep_check_stock1'] = tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty']);
    }

    if ( (isset($order->products[$i]['attributes'])) && (sizeof($order->products[$i]['attributes']) > 0) ) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
      }
    }
    if (sizeof($order->info['tax_groups']) > 1){
	  $order->products[$i]['tep_display_tax_value1'] = tep_display_tax_value($order->products[$i]['tax']);
	}
    $order->products[$i]['display_price'] = $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']);
  }

  $tep_address_format2 = tep_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br>');
  $tep_href_link6 = tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL');

  if (MODULE_ORDER_TOTAL_INSTALLED) {
    $order_total_modules->process();
    $order_total_modules_output1 = $order_total_modules->output();
  }

  // {*3*}
  $confirmation = $payment_modules->confirmation();
  // {*4*}
  if (tep_not_null($order->info['comments'])) {
	$nl2br1 = nl2br(tep_output_string_protected($order->info['comments']));
	  $tep_draw_hidden_field1 = tep_draw_hidden_field('comments', $order->info['comments']);
  }

  if (isset($_SESSION['payment']->form_action_url)) {
    $form_action_url1 = $_SESSION['payment']->form_action_url;
  } else {
    $form_action_url1 = tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL');
  }
  $tep_draw_form1 = tep_draw_form('checkout_confirmation', $form_action_url1, 'post');

  if (is_array($payment_modules->modules)) {
    $payment_modules_process_button1 =  $payment_modules->process_button();
  }else{
	$payment_modules_process_button1 = '';
  }

  // old htmlpage was here
  $t->assign(array(
				   'confirmation' => $confirmation,
				   'nl2br1' => $nl2br1,
				   'order' => $order,
				   'order_total_modules_output1' => $order_total_modules_output1,
				   'payment_modules' => $payment_modules,
				   'payment_modules_process_button1' => $payment_modules_process_button1,
				   'sizeof1' => $sizeof1,
				   'tep_address_format1' => $tep_address_format1,
				   'tep_address_format2' => $tep_address_format2,
				   'tep_draw_form1' =>  $tep_draw_form1,
				   'tep_draw_hidden_field1' => $tep_draw_hidden_field1,

));

  //$t->assign('body_template', 'checkout_confirmation.html');
  tep_assign_template($t,'body_template', 'checkout_confirmation.html');
  $t->display('layout.html');


}
?>
