<?php {
  /*
  $Id: checkout_payment.php,v 1.1.1.1 2004/01/07 09:18:18 shota Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  */

  require('../lib/catalog/application_top.php');

  // if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $_SESSION["navigation"]->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

  // if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($_SESSION["cart"]->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

  // if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping')) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }

  // avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($_SESSION["cart"]->cartID) && tep_session_is_registered('cartID')) {
    if ($_SESSION['cart']->cartID != $_SESSION['cartID']) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

  // Stock Check
  if ( (STOCK_CHECK == 'true') && (STOCK_ALLOW_CHECKOUT != 'true') ) {
    $products = $_SESSION["cart"]->get_products();
    for ($i=0, $n=sizeof($products); $i<$n; $i++) {
      if (tep_check_stock($products[$i]['id'], $products[$i]['quantity'])) {
        tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
        break;
      }
    }
  }

  // if no billing destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('billto')) {
    tep_session_register('billto');
    $_SESSION['billto'] = $_SESSION['customer_default_address_id'];

  } else {
    // verify the selected billing address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$_SESSION['customer_id'] . "' and address_book_id = '" . (int)$_SESSION['billto'] . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $_SESSION['billto'] = $_SESSION['customer_default_address_id'];
      if (tep_session_is_registered('payment')) tep_session_unregister('payment');
    }
  }

  require(DIR_FS_CLASSES . 'order.php');
  $order = new order;

  if (!tep_session_is_registered('comments')) tep_session_register('comments');

  $total_weight = $_SESSION["cart"]->show_weight();
  $total_count = $_SESSION['cart']->count_contents();

  // load all enabled payment modules
  require(DIR_FS_CLASSES . 'payment.php');
  $payment_modules = new payment;

  require(DIR_FS_LANGUAGES . $_SESSION['language'] . '/' . FILENAME_CHECKOUT_PAYMENT);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));


  $payment_modules_javasclipt_validation1 = $payment_modules->javascript_validation();
  $tep_draw_form1 = tep_draw_form('checkout_payment', tep_href_link(FILENAME_CHECKOUT_CONFIRMATION, '', 'SSL'), 'post', 'onsubmit="return check_form();"');

  // {*1*}
  if (isset($_GET['payment_error'])  && ($error = ${$_GET['payment_error']}->get_error())) {
    $tep_output_string_protected1 = tep_output_string_protected($error['title']);
    $tep_output_string_protected2 = tep_output_string_protected($error['error']);
  }

  $selection = $payment_modules->selection();

  // {*2*}
  for ($i=0, $n=sizeof($selection); $i<$n; $i++) {
    $selection[$i]['tep_draw_radio_field'] = tep_draw_radio_field('payment', $selection[$i]['id']);
    $selection[$i]['tep_draw_hidden_field'] = tep_draw_hidden_field('payment', $selection[$i]['id']);
    if ( ($selection[$i]['id'] == $_SESSION['payment']) || ($n == 1) ) {
      if (isset($selection[$i]['error'])) {
      } elseif (isset($selection[$i]['fields']) && is_array($selection[$i]['fields'])) {
	for ($j=0, $n2=sizeof($selection[$i]['fields']); $j<$n2; $j++) {
	}
      }
    }
  }
  $tep_draw_textarea_field1 = tep_draw_textarea_field('comments', 'soft', '60', '5', $_SESSION['comments']);
  $tep_href_link2 = tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL');
 

  // old htmlpage was here
  $t->assign(array(
		   'payment_modules_javasclipt_validation1' => $payment_modules_javasclipt_validation1,
		   'error' => $error,
		   'selection' => $selection,
		   'request_type' => $request_type,
		   'tep_draw_form1' =>  $tep_draw_form1,
		   'tep_draw_textarea_field1' => $tep_draw_textarea_field1,
		   'tep_output_string_protected1' => $tep_output_string_protected1,
		   'tep_output_string_protected2' => $tep_output_string_protected2,


		   ));
  tep_assign_template($t,'body_template', 'checkout_payment.html');
  $t->display('layout.html');

}
?>
