<?php {
  /*
  $Id: create_account.php,v 1.1.1.1 2004/01/07 09:18:18 shota Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  */

  require('../lib/catalog/application_top.php');

  // needs to be included earlier to set the success message in the messageStack
  require(DIR_FS_LANGUAGES . $_SESSION["language"] . '/' . FILENAME_CREATE_ACCOUNT);

  $process = false;
  if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    $process = true;

    if (ACCOUNT_GENDER == 'true') {
      if (isset($_POST['gender'])) {
        $gender = tep_db_prepare_input($_POST['gender']);
      } else {
        $gender = false;
      }
    }
    $firstname = tep_db_prepare_input($_POST['firstname']);
    $lastname = tep_db_prepare_input($_POST['lastname']);
    if (ACCOUNT_DOB == 'true') $dob = tep_db_prepare_input($_POST['dob']);
    $email_address = tep_db_prepare_input($_POST['email_address']);
    if (ACCOUNT_COMPANY == 'true') $company = tep_db_prepare_input($_POST['company']);
    $street_address = tep_db_prepare_input($_POST['street_address']);
    if (ACCOUNT_SUBURB == 'true') $suburb = tep_db_prepare_input($_POST['suburb']);
    $postcode = tep_db_prepare_input($_POST['postcode']);
    $city = tep_db_prepare_input($_POST['city']);
    if (ACCOUNT_STATE == 'true') {
      $state = tep_db_prepare_input($_POST['state']);
      if (isset($_POST['zone_id'])) {
        $zone_id = tep_db_prepare_input($_POST['zone_id']);
      } else {
        $zone_id = false;
      }
    }
    $country = tep_db_prepare_input($_POST['country']);
    $telephone = tep_db_prepare_input($_POST['telephone']);
    $fax = tep_db_prepare_input($_POST['fax']);

	
    if (isset($_POST['newsletter'])) {
      $newsletter = tep_db_prepare_input($_POST['newsletter']);
    } else {
      $newsletter = false;
    }
	
    $password = tep_db_prepare_input($_POST['password']);
    $confirmation = tep_db_prepare_input($_POST['confirmation']);

    $error = false;
	
    if (ACCOUNT_GENDER == 'true') {
      if ( ($gender != 'm') && ($gender != 'f') ) {
        $error = true;
        $messageStack->add('create_account', ENTRY_GENDER_ERROR);
      }
    }

    if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_FIRST_NAME_ERROR);
    }

    if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_LAST_NAME_ERROR);
    }

    if (ACCOUNT_DOB == 'true') {
      if (checkdate(substr(tep_date_raw($dob), 4, 2), substr(tep_date_raw($dob), 6, 2), substr(tep_date_raw($dob), 0, 4)) == false) {
        $error = true;
        $messageStack->add('create_account', ENTRY_DATE_OF_BIRTH_ERROR);
      }
    }

    if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR);
    } elseif (tep_validate_email($email_address) == false) {
      $error = true;
      $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
    } else {
      $check_email_query = tep_db_query("select count(*) as total from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($email_address) . "'");
      $check_email = tep_db_fetch_array($check_email_query);
      if ($check_email['total'] > 0) {
        $error = true;
        $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);
      }
    }

    if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_STREET_ADDRESS_ERROR);
    }

    if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_POST_CODE_ERROR);
    }

    if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_CITY_ERROR);
    }

    if (is_numeric($country) == false) {
      $error = true;
      $messageStack->add('create_account', ENTRY_COUNTRY_ERROR);
    }

    if (ACCOUNT_STATE == 'true') {
      $zone_id = 0;
      $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "'");
      $check = tep_db_fetch_array($check_query);
      $entry_state_has_zones = ($check['total'] > 0);
      if ($entry_state_has_zones == true) {
        $zone_query = tep_db_query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and (zone_name like '" . tep_db_input($state) . "%' or zone_code like '%" . tep_db_input($state) . "%')");
        if (tep_db_num_rows($zone_query) == 1) {
          $zone = tep_db_fetch_array($zone_query);
          $zone_id = $zone['zone_id'];
        } else {
          $error = true;
          $messageStack->add('create_account', ENTRY_STATE_ERROR_SELECT);
        }
      } else {
        if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
          $error = true;
          $messageStack->add('create_account', ENTRY_STATE_ERROR);
        }
      }
    }

    if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_TELEPHONE_NUMBER_ERROR);
    }


    if (strlen($password) < ENTRY_PASSWORD_MIN_LENGTH) {
      $error = true;
      $messageStack->add('create_account', ENTRY_PASSWORD_ERROR);
    } elseif ($password != $confirmation) {
      $error = true;

      $messageStack->add('create_account', ENTRY_PASSWORD_ERROR_NOT_MATCHING);
    }

    if ($error == false) {
      $sql_data_array = array('customers_firstname' => $firstname,
                              'customers_lastname' => $lastname,
                              'customers_email_address' => $email_address,
                              'customers_telephone' => $telephone,
                              'customers_fax' => $fax,
                              'customers_newsletter' => $newsletter,
                              'customers_password' => tep_encrypt_password($password));

      if (ACCOUNT_GENDER == 'true') $sql_data_array['customers_gender'] = $gender;
      if (ACCOUNT_DOB == 'true') $sql_data_array['customers_dob'] = tep_date_raw($dob);

      tep_db_perform(TABLE_CUSTOMERS, $sql_data_array);

      $_SESSION["customer_id"] = tep_db_insert_id('customers_id_seq');

      $sql_data_array = array('customers_id' => $_SESSION["customer_id"],
                              'entry_firstname' => $firstname,
                              'entry_lastname' => $lastname,
                              'entry_street_address' => $street_address,
                              'entry_postcode' => $postcode,
                              'entry_city' => $city,
                              'entry_country_id' => $country);

      if (ACCOUNT_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;
      if (ACCOUNT_COMPANY == 'true') $sql_data_array['entry_company'] = $company;
      if (ACCOUNT_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;
      if (ACCOUNT_STATE == 'true') {
        if ($zone_id > 0) {
          $sql_data_array['entry_zone_id'] = $zone_id;
          $sql_data_array['entry_state'] = '';
        } else {
          $sql_data_array['entry_zone_id'] = '0';
          $sql_data_array['entry_state'] = $state;
        }
      }

      tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);

      $address_id = tep_db_insert_id('address_book_id_seq');

      tep_db_query("update " . TABLE_CUSTOMERS . " set customers_default_address_id = '" . (int)$address_id . "' where customers_id = '" . (int)$_SESSION["customer_id"] . "'");

      tep_db_query("insert into " . TABLE_CUSTOMERS_INFO . " (customers_info_id, customers_info_number_of_logons, customers_info_date_account_created) values ('" . (int)$_SESSION["customer_id"] . "', '0', now())");

      if (SESSION_RECREATE == 'True') {
        tep_session_recreate();
      }

      $customer_first_name = $firstname;
      $customer_last_name = $lastname;
      $_SESSION["customer_default_address_id"] = $address_id;
      $customer_country_id = $country;
      $customer_zone_id = $zone_id;
      tep_session_register('customer_id');
      tep_session_register('customer_first_name');
      tep_session_register('customer_last_name');
      tep_session_register('customer_default_address_id');
      tep_session_register('customer_country_id');
      tep_session_register('customer_zone_id');

      // restore cart contents
      $_SESSION["cart"]->restore_contents();

      // build the message content
      $name = tep_get_fullname2($firstname, $lastname, $customer_country_id);

      if (ACCOUNT_GENDER == 'true') {
	if ($gender == 'm') {
	  $email_text = sprintf(EMAIL_GREET_MR, $lastname);
	} else {
	  $email_text = sprintf(EMAIL_GREET_MS, $lastname);
	}
      } else {
        $email_text = sprintf(EMAIL_GREET_NONE, $firstname);
      }

      $email_text .= EMAIL_WELCOME . EMAIL_TEXT . EMAIL_CONTACT . EMAIL_WARNING;
      tep_mail($name, $email_address, EMAIL_SUBJECT, $email_text, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
      tep_redirect(tep_href_link(FILENAME_CREATE_ACCOUNT_SUCCESS, '', 'SSL'));
    }
  }

  $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));
  $messageStack_size1 = $messageStack->size('create_account');
  $t->assign('messageStack_size1', $messageStack_size1);
  if($messageStack->size('create_account') > 0){
    $messageStack_output1 = $messageStack->output('create_account');
  }
  $t->assign('messageStack_output1', $messageStack_output1);
  $tep_draw_form1 = tep_draw_form('create_account', tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'), 'post', 'onSubmit="return check_form(create_account);"') . tep_draw_hidden_field('action', 'process');
  $t->assign('tep_draw_form1', $tep_draw_form1);
  $sprintf1 = sprintf(TEXT_ORIGIN_LOGIN, tep_href_link(FILENAME_LOGIN, tep_get_all_get_params(), 'SSL'));
  $t->assign('sprintf1', $sprintf1);
  $tep_draw_radio_field1 = tep_draw_radio_field('gender', 'm');
  $t->assign('tep_draw_radio_field1', $tep_draw_radio_field1);
  $tep_draw_radio_field2 = tep_draw_radio_field('gender', 'f');
  $t->assign('tep_draw_radio_field2', $tep_draw_radio_field2);
  $tep_draw_input_field1 = tep_draw_input_field('firstname');
  $t->assign('tep_draw_input_field1', $tep_draw_input_field1);
  $tep_draw_input_field2 = tep_draw_input_field('lastname');
  $t->assign('tep_draw_input_field2', $tep_draw_input_field2);
  $tep_draw_input_field3 = tep_draw_input_field('dob');
  $t->assign('tep_draw_input_field3', $tep_draw_input_field3);
  $tep_draw_input_field4 = tep_draw_input_field('email_address');
  $t->assign('tep_draw_input_field4', $tep_draw_input_field4);
  $tep_draw_input_field5 = tep_draw_input_field('company');
  $t->assign('tep_draw_input_field5', $tep_draw_input_field5);
  $tep_draw_input_field6 = tep_draw_input_field('street_address');
  $t->assign('tep_draw_input_field6', $tep_draw_input_field6);
  $tep_draw_input_field7 = tep_draw_input_field('suburb');
  $t->assign('tep_draw_input_field7', $tep_draw_input_field7);
  $tep_draw_input_field8 = tep_draw_input_field('postcode');
  $t->assign('tep_draw_input_field8', $tep_draw_input_field8);
  $tep_draw_input_field9 = tep_draw_input_field('city');
  $t->assign('tep_draw_input_field9', $tep_draw_input_field9);
  //{*1*}

  if (ACCOUNT_STATE == 'true') {
    if ($process == true) {
      if ($entry_state_has_zones == true) {
        $zones_array = array();
        $zones_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' order by zone_name");
        while ($zones_values = tep_db_fetch_array($zones_query)) {
          $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
        }
        $tep_draw_pull_down_menu1 = tep_draw_pull_down_menu('state', $zones_array);
      } else {
	$tep_draw_input_field10 = tep_draw_input_field('state');
      }
    } else {
      $tep_draw_input_field11 = tep_draw_input_field('state');
    }
  }
  $t->assign('process', $process);
  $t->assign('entry_state_has_zones', $entry_state_has_zones);
  $tep_get_country_list1 = tep_get_country_list('country');
  $tep_draw_input_field12 = tep_draw_input_field('telephone');
  $tep_draw_input_field13 = tep_draw_input_field('fax');
  $tep_draw_checkbox_field1 = tep_draw_checkbox_field('newsletter', '1');
  $tep_draw_password_field1 = tep_draw_password_field('password');
  $tep_draw_password_field2 = tep_draw_password_field('confirmation');

  $t->assign(array('tep_draw_pull_down_menu1' => $tep_draw_pull_down_menu1, 'tep_draw_input_field10' => $tep_draw_input_field10, 'tep_draw_input_field11' => $tep_draw_input_field11, 'tep_get_country_list1' => $tep_get_country_list1, 'tep_draw_input_field12' => $tep_draw_input_field12, 'tep_draw_input_field13' => $tep_draw_input_field13, 'tep_draw_checkbox_field1' => $tep_draw_checkbox_field1, 'tep_draw_password_field1' => $tep_draw_password_field1, 'tep_draw_password_field2' => $tep_draw_password_field2));
	
  // old htmlpage was here
  tep_assign_template($t,'body_template', 'create_account.html');
  $t->display('layout.html');

}
?>
