<?php
/*
  $Id: database.php,v 1.1.1.1 2004/01/07 09:18:18 shota Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  if (version_compare(phpversion(), "4.2.0") == -1) {

    function pg_query($link, $query) {
	  return pg_exec($link, $query);
    }

	function pg_num_rows($db_query) {
	  return pg_numrows($db_query);
	}

	function pg_last_error() {
	  return pg_errormessage();
	}

	function pg_result_error($result) {
      return pg_errormessage($result);
	}

	function pg_fetch_result($result, $a, $b) {
	  return pg_result($result, $a, $b);
	}

	function pg_free_result($db_query) {
      return pg_freeresult($db_query);
	}

  }

  function tep_db_connect($server = DB_SERVER, $username = DB_SERVER_USERNAME, $password = DB_SERVER_PASSWORD, $database = DB_DATABASE, $link = 'db_link', $port = 5432) {
    global $$link;
	if(empty($server)){
	  $conn_string = "dbname=$database user=$username password=$password";
	}else {
	  $conn_string = "host=$server port=$port dbname=$database user=$username password=$password";
	}
    if (USE_PCONNECT == 'true') {
      $$link = pg_pconnect($conn_string);
    } else {
      $$link = pg_connect($conn_string);
    }

    return $$link;
  }

  function tep_db_close($link = 'db_link') {
    global $$link;

    return pg_close($$link);
  }

  function tep_db_error($query, $errno, $error) { 
    die('<font color="#000000"><b>' . $errno . ' - ' . $error . '<br><br>' . $query . '<br><br><small><font color="#ff0000">[TEP STOP]</font></small><br><br></b></font>');
  }

  function tep_db_query($query, $link = 'db_link') {
    global $$link;
    global $pg_row;

    if (defined('STORE_DB_TRANSACTIONS') && (STORE_DB_TRANSACTIONS == 'true')) {
      error_log('QUERY ' . $query . "\n", 3, STORE_PAGE_PARSE_TIME_LOG);
    }

    $result = @pg_query($$link, $query) or tep_db_error($query, '', pg_last_error());
    $pg_row[$result] = -1;

    if (defined('STORE_DB_TRANSACTIONS') && (STORE_DB_TRANSACTIONS == 'true')) {
       $result_error = pg_result_error($result);
       error_log('RESULT ' . $result . ' ' . $result_error . "\n", 3, STORE_PAGE_PARSE_TIME_LOG);
    }

    return $result;
  }

  function tep_db_perform($table, $data, $action = 'insert', $parameters = '', $link = 'db_link') {
    reset($data);
    if ($action == 'insert') {
      $query = 'insert into ' . $table . ' (';
      while (list($columns, ) = each($data)) {
        $query .= $columns . ', ';
      }
      $query = substr($query, 0, -2) . ') values (';
      reset($data);
      while (list(, $value) = each($data)) {
        switch ((string)$value) {
          case 'now()':
            $query .= 'now(), ';
            break;
          case 'null':
            $query .= 'null, ';
            break;
          default:
            $query .= '\'' . tep_db_input($value) . '\', ';
            break;
        }
      }
      $query = substr($query, 0, -2) . ')';
    } elseif ($action == 'update') {
      $query = 'update ' . $table . ' set ';
      while (list($columns, $value) = each($data)) {
        switch ((string)$value) {
          case 'now()':
            $query .= $columns . ' = now(), ';
            break;
          case 'null':
            $query .= $columns .= ' = null, ';
            break;
          default:
            $query .= $columns . ' = \'' . tep_db_input($value) . '\', ';
            break;
        }
      }
      $query = substr($query, 0, -2) . ' where ' . $parameters;
    }

    return tep_db_query($query, $link);
  }

  function tep_db_fetch_array($db_query) {
    global $pg_row;

    if (++$pg_row[$db_query] >= pg_num_rows($db_query))
    {
      $pg_row[$db_query] = -1;
      return false;
    }

    return pg_fetch_array($db_query, $pg_row[$db_query], PGSQL_ASSOC);
  }

  function tep_db_num_rows($db_query) {
    return pg_num_rows($db_query);
  }

  function tep_db_data_seek($db_query, $row_number) {
    global $pg_row;

    $pg_row[$db_query] = $row_number - 1;
  }

  function tep_db_insert_id($sequence_name, $link = 'db_link') {
    global $$link;

    $result = @pg_query($$link, "SELECT currval('" . $sequence_name . "')") or tep_db_error($query, '', pg_last_error());

    return pg_fetch_result($result, 0, 0);
  }

  function tep_db_free_result($db_query) {
    global $pg_row;

    unset($pg_row[$db_query]);
    return pg_free_result($db_query);
  }

  function tep_db_fetch_fields($db_query) {
//    return mysql_fetch_field($db_query);
    die("tep_db_fetch_fields($db_query)");
  }

  function tep_db_output($string) {
    return htmlspecialchars($string);
  }

  function tep_db_input($string) {
    return addslashes($string);
  }

  function tep_db_prepare_input($string) {
    if (is_string($string)) {
      return trim(tep_sanitize_string(stripslashes($string)));
    } elseif (is_array($string)) {
      reset($string);
      while (list($key, $value) = each($string)) {
        $string[$key] = tep_db_prepare_input($value);
      }
      return $string;
    } else {
      return $string;
    }
  }

  function tep_db_input_numeric($string) {
    return (int)(is_numeric($string) ? $string : 0);
  }

// examples: 2, 2{4}4{3}7
  function get_int_from_what_the_hell_is_this($what) {
    $pos = strpos($what, '{');

    if ($pos>0) return substr($what, 0, $pos);
    else return $what;
  }
?>
