<?php {
/*
  $Id: function.osc_general.php,v 1.1.1.1 2004/01/07 09:18:18 shota Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

////
// Stop from parsing any further PHP code
  function smarty_function_osc_exit() {
	return tep_exit();
  }

  /* wrapper for tep_redirect
   * @param  $url   string   url
   * @return        void
   */
  function smarty_function_osc_redirect($params) {
	extract($params);
	return tep_redirect($url);
    tep_exit();
  }

  /* Parse the data used in the html tags to ensure the tags will not break
   * @param  $data   string
   * @param  $parse  string
   * @return         string
   */
  function smarty_function_osc_parse_input_field_data($params) {
	extract($params);
	return tep_parse_input_field_data($data, $parse);
  }

  /* 
   * @param    $string      string
   * @param    $translage   bool
   * @return   $protected   bool  
   */
  function smarty_function_osc_output_string($params) {
	extract($params);
	if(empty($translate)){
	  $translate = false;
	}
	if(empty($protected)){
	  $protected = false;
	}
	return tep_output_string($string, $translate = false, $protected = false);
  }

  function smarty_function_osc_output_string_protected($params) {
    return smarty_function_osc_output_string($params);
  }

  /* 
   * @param    $string      string
   * @return                string  
   */
  function smarty_function_osc_sanitize_string($string) {
	extract($params);
	return tep_sanitize_string($string);
  }

////
// Return a random row from a database query
  /* 
   * @param    $query       string
   * @return                array
   */
  function smarty_function_osc_random_select($params) {
	extract($params);
	return tep_random_select($query);
  }

////
// Return a product's name
// TABLES: products
  /* 
   * @param    $products_id  integer
   * @param    $language    string
   * @return                string
   */
  function smarty_function_osc_get_products_name($params) {
	extract($params);
    if (empty($language)) $language = $_SESSION['languages_id'];
	return tep_get_products_name($products_id, $language);
  }

////
// Return a product's special price (returns nothing if there is no offer)
// TABLES: products
  /* 
   * @param    $products_id  integer
   * @return                string
   */
  function smarty_function_osc_get_products_special_price($params) {
	extract($params);
	return tep_get_products_special_price($products_id);
  }

////
// Return a product's stock
// TABLES: products
  /* 
   * @param    $products_id  integer
   * @return                int
   */
  function smarty_function_osc_get_products_stock($params) {
	extract($params);
	return tep_get_products_stock($products_id);
  }

////
// Check if the required stock is available
// If insufficent stock is available return an out of stock message
  /* 
   * @param    $products_id  integer
   * @param    $products_quantity  integer
   * @return                 string
   */
  function smarty_function_osc_check_stock($params) {
	extract($params);
	return tep_check_stock($products_id, $products_quantity);
  }

////
// Returns an array with countries
// TABLES: countries
  /* 
   * @param    $countries_id   integer
   * @param    $with_iso_codes bool
   * @return                   array
   */
  function smarty_function_osc_get_countries($params) {
	extract($params);
	if(empty($countries_id)) $countries_id = '';
	if(empty($with_iso_codes)) $with_iso_codes = false;
	return tep_get_countries($countries_id, $with_iso_codes);
  }

////
// Alias function to tep_get_countries, which also returns the countries iso codes
  /* 
   * @param    $countries_id   integer
   * @return                   string
   */
  function smarty_function_osc_get_countries_with_iso_codes($params) {
	extract($params);
    return tep_get_countries($countries_id, true);
  }

////
// Generate a path to categories
  /* 
   * @param    $current_category_id   integer
   * @return                   string
   */
  function smarty_function_osc_get_path($params) {
	extract($params);
	if(empty($current_category_id)) $current_category_id ='';
	return tep_get_path($current_category_id = '');
  }

// Alias function to tep_get_countries()
  /* 
   * @param    $countries_id   integer
   * @return                   array
   */
  function smarty_function_osc_get_country_name($params) {
	extract($params);
    return tep_get_country_name($country_id);
  }

////
// Returns the zone (State/Province) name
// TABLES: zones
  /* 
   * @param    $countries_id   integer
   * @param    $zone_id        integer
   * @param    $default_zone          
   * @return                   
   */
  function smarty_function_osc_get_zone_name($params) {
	extract($params);
	return tep_get_zone_name($country_id, $zone_id, $default_zone);
  }

////
// Returns the zone (State/Province) code
// TABLES: zones
  /* 
   * @param    $countries_id   integer
   * @param    $zone_id        integer
   * @param    $default_zone          
   * @return                   
   */
  function smarty_function_osc_get_zone_code($params) {
	extract($params);
	return tep_get_zone_code($country_id, $zone_id, $default_zone);
  }

////
// Returns the tax rate for a zone / class
// TABLES: tax_rates, zones_to_geo_zones
  /* 
   * @param    $class_id       integer
   * @param    $country_id     integer
   * @param    $zone_id        int          
   * @return                   
   */
  function smarty_function_osc_get_tax_rate($params) {
	extract($params);
	if(empty($country_id)) $country_id = -1;
	if(empty($zone_id)) $zone_id = -1;
	return tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1);
  }

////
// Return the tax description for a zone / class
// TABLES: tax_rates;
  /* 
   * @param    $class_id       integer
   * @param    $country_id     integer
   * @param    $zone_id        int          
   * @return                   
   */
  function smarty_function_osc_get_tax_description($params) {
	extract($params);
	return tep_get_tax_description($class_id, $country_id, $zone_id);
  }

////
// Add tax to a products price
  /* 
   * @param    $price          integer
   * @param    $tax            integer
   * @return                   
   */
  function smarty_function_osc_add_tax($params) {
	extract($params);
	return tep_add_tax($price, $tax);
  }

// Calculates Tax rounding the result
  /* 
   * @param    $price          integer
   * @param    $tax            integer
   * @return                   
   */
  function smarty_function_osc_calculate_tax($params) {
	extract($params);
	return tep_calculate_tax($price, $tax);
  }

////
// Return the number of products in a category
// TABLES: products, products_to_categories, categories
  /* 
   * @param    $category_id         integer
   * @param    $include_inactive    bool   
   * @return                        int
   */
  function smarty_function_osc_count_products_in_category($params) {
	extract($params);
	if(empty($include_inactive)) $include_inactive=false;
	return tep_count_products_in_category($category_id, $include_inactive);
  }


////
// Return true if the category has subcategories
// TABLES: categories
  function smarty_function_osc_has_category_subcategories($category_id) {
	extract($params);
  }

////
// Returns the address_format_id for the given country
// TABLES: countries;
  function smarty_function_osc_get_address_format_id($country_id) {
	extract($params);

  }

////
// Return a formatted address
// TABLES: address_format
  function smarty_function_osc_address_format($address_format_id, $address, $html, $boln, $eoln) {
	extract($params);

  }

////
// Return a formatted address
// TABLES: address_book, address_format
  function smarty_function_osc_address_summary($customers_id, $address_id) {
	extract($params);

  }

  function smarty_function_osc_row_number_format($number) {
	extract($params);

  }

  function smarty_function_osc_get_categories($categories_array = '', $parent_id = '0', $indent = '') {
	extract($params);

    return $categories_array;
  }

  function smarty_function_osc_get_manufacturers($manufacturers_array = '') {
	extract($params);

    return $manufacturers_array;
  }

////
// Return all subcategory IDs
// TABLES: categories
  function smarty_function_osc_get_subcategories(&$subcategories_array, $parent_id = 0) {
	extract($params);

  }

////
// Output a raw date string in the selected locale date format
// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
// NOTE: Includes a workaround for dates before 01/01/1970 that fail on windows servers
  function smarty_function_osc_date_short($raw_date) {
	extract($params);

  }

////
// Parse search string into indivual objects
  function smarty_function_osc_parse_search_string($search_str = '', &$objects) {
	extract($params);

  }

////
// Check date
  function smarty_function_osc_checkdate($date_to_check, $format_string, &$date_array) {
	extract($params);

  }

////
// Check if year is a leap year
  function smarty_function_osc_is_leap_year($year) {
	extract($params);

  }

////
// Return table heading with sorting capabilities
  function smarty_function_osc_create_sort_heading($sortby, $colnum, $heading) {
	extract($params);

  }
////
// Recursively go through the categories and retreive all parent categories IDs
// TABLES: categories
  function smarty_function_osc_get_parent_categories(&$categories, $categories_id) {
	extract($params);

  }

////
// Construct a category path to the product
// TABLES: products_to_categories
  function smarty_function_osc_get_product_path($products_id) {
	extract($params);

  }

////
// Return a product ID with attributes
  function smarty_function_osc_get_uprid($prid, $params) {
	extract($params);

    return $uprid;
  }

////
// Return a product ID from a product ID with attributes
  function smarty_function_osc_get_prid($uprid) {
	extract($params);

    return $pieces[0];
  }


////
//! Send email (text/html) using MIME
// This is the central mail function. The SMTP Server should be configured
// correct in php.ini
// Parameters:
// $to_name           The name of the recipient, e.g. "Jan Wildeboer"
// $to_email_address  The eMail address of the recipient,
//                    e.g. jan.wildeboer@gmx.de
// $email_subject     The subject of the eMail
// $email_text        The text of the eMail, may contain HTML entities
// $from_email_name   The name of the sender, e.g. Shop Administration
// $from_email_adress The eMail address of the sender,
//                    e.g. info@mytepshop.com

  function smarty_function_osc_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name, $from_email_address) {
	extract($params);

  }

////
// Check if product has attributes
  function smarty_function_osc_has_product_attributes($products_id) {
	extract($params);

  }

////
// Get the number of times a word/character is present in a string
// return string length in Japanese
  function smarty_function_osc_word_count($string, $needle) {
	extract($params);

  }

  function smarty_function_osc_count_modules($modules = '') {
	extract($params);

  }

  function smarty_function_osc_count_payment_modules() {
	extract($params);
    return tep_count_modules(MODULE_PAYMENT_INSTALLED);
  }

  function smarty_function_osc_count_shipping_modules() {
	extract($params);
    return tep_count_modules(MODULE_SHIPPING_INSTALLED);
  }

  function smarty_function_osc_create_random_value($length, $type = 'mixed') {
	extract($params);

    return $rand_value;
  }

  function smarty_function_osc_array_to_string($array, $exclude = '', $equals = '=', $separator = '&') {
	extract($params);

    return $get_string;
  }

////
// Output the tax percentage with optional padded decimals
  function smarty_function_osc_display_tax_value($value, $padding = TAX_DECIMAL_PLACES) {
	extract($params);

    return $value;
  }

////
// Checks to see if the currency code exists as a currency
// TABLES: currencies
  function smarty_function_osc_currency_exists($code) {
	extract($params);

  }

  function smarty_function_osc_string_to_int($string) {
	extract($params);
    return (int)$string;
  }

////
// Parse and secure the cPath parameter values
  function smarty_function_osc_parse_category_path($cPath) {
	extract($params);

    return $tmp_array;
  }

////
// Return a random value
  function smarty_function_osc_rand($min = null, $max = null) {
	extract($params);

  }

  function smarty_function_osc_setcookie($name, $value = '', $expire = 0, $path = '/', $domain = '', $secure = 0) {
	extract($params);

  }

  function smarty_function_osc_get_ip_address() {
	extract($params);

    return $ip;
  }

  function smarty_function_osc_count_customer_orders($id = '', $check_session = true) {
	extract($params);

    return $orders_check['total'];
  }

  function smarty_function_osc_count_customer_address_book_entries($id = '', $check_session = true) {
	extract($params);

    return $addresses['total'];
  }

// nl2br() prior PHP 4.2.0 did not convert linefeeds on all OSs (it only converted \n)
  function smarty_function_osc_convert_linefeeds($from, $to, $string) {
	extract($params);

  }

  // Convert "zen-kaku" alphabets and numbers to "han-kaku"
  // tamura 2002/12/30
  function smarty_function_osc_an_zen_to_han($string) {
	extract($params);

  }

////
// Return fullname
// for Japanese Localize
  function smarty_function_osc_get_fullname($firstname, $lastname) {
	extract($params);

  }

  function smarty_function_osc_get_fullname2($firstname, $lastname, $country_id = 107) {
	extract($params);

  }

}?>
