<?php 
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.0【日本語版】
// opencart.jp
// japan_post.php
// このファイルは、日本郵便のゆうパックの配送モジュールです(model)。
// ver 1.0.0 Coding By sae
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
//クラス名はキャメルで書きます。
class ModelShippingJapanPost extends Model {
	
	public function getQuote($address) {
		//このモジュールのlanguageファイルをロードします。
		$this->load->language('shipping/japan_post');
		
		$error = '';
		
		//このモジュールの設定をデータベースより読み込みます。settingテーブルです。ステータスが有効ならば
		if ($this->config->get('japan_post_status') && (int)$address['country_id'] == 107 ) {
      		
			$zone = (int)$address['zone_id'];
			
			$main_price = $this->config->get('japan_post_price');
			
			switch( $main_price ){
			
				case 'di':
					//北海道
					$zone_array['ho_p'] = array( '1668' );
					//東北
					$zone_array['to_p'] = array( '1659', '1658', '1672', '1680', '1701', '1664' );
					//関東
					$zone_array['ka_p'] = array( '1697', '1675', '1691', '1660', '1670', '1695', '1666', '1703' );
					//信越
					$zone_array['shi_p'] = array( '1685', '1682' );
					//北陸
					$zone_array['hoku_p'] = array( '1699', '1671', '1662' );
					//東海
					$zone_array['tou_p'] = array( '1657', '1665', '1694', '1679' );
					//近畿
					$zone_array['ki_p'] = array( '1689', '1669', '1678', '1692', '1684', '1700' );
					//中国
					$zone_array['chu_p'] = array( '1698', '1693', '1678', '1667', '1702' );
					//四国
					$zone_array['shiko_p'] = array( '1696', '1673', '1661', '1676' );
					//九州
					$zone_array['kyu_p'] = array( '1663', '1690', '1683', '1677', '1686', '1680', '1674' );
					//沖縄
					$zone_array['oki_p'] = array( '1688' );
					
					foreach( $zone_array as $key => $val ){
					
						foreach( $zone_array[$key] as $zone_id ){
						
							if( $zone_id == $zone ){
								
								$price_key = $key;
								
								break;	
							
							}//if-end
						
						}//foreach-end
					
					}//foreach-end
					
					$subtotal = (int)$this->cart->getSubTotal();
					
					if( $this->config->get( $price_key . '_free') <= $subtotal){
									
						$cost = 0;
						
					}else{
					
						$cost = (int)$this->config->get($price_key);
					
					}
					
					$cost_text = $this->currency->format( $cost );
					
					$quote_data['japan_post'] = array(
								'id'           => 'japan_post.japan_post',
								'title'        => $this->language->get('text_title'),
								'cost'         => $cost,
								'tax_class_id' => 0,
								'text'         => $cost_text
							);
					break;
					
				case 'ev':
				
					$subtotal = (int)$this->cart->getSubTotal();
					
					if( $this->config->get('japan_post_evenly_free') <= $subtotal){
									
						$cost = 0;
						
					}else{
					
						$cost = (int)$this->config->get('japan_post_evenly');
					
					}
					
					$cost_text = $this->currency->format( $cost );
					
					$quote_data['japan_post'] = array(
								'id'           => 'japan_post.japan_post',
								'title'        => $this->language->get('text_title'),
								'cost'         => $cost,
								'tax_class_id' => 0,
								'text'         => $cost_text
							);
					break;
					
				case 'pu':
				
					$cost_quote_array = explode( ',', $this->config->get('japan_post_evenly') );
					
					$cost_count = count( $cost_quote_array );
					
					for( $i = 0; $i < $cost_cunt; $i++ ){
					
						$price_array[] = explode( ':', $cost_quote_array );
					
					}//for-end
					
					$price_count = count( $price_array );
					
					$subtotal = $this->cart->getSubTotal();
					
					for( $i = 0; $i < $price_count; $i++ ){
					
						if( $price_array[$i][0] <= $subTotal && $price_array[$i][1] > $subtotal ){
						
							$cost_quote = $price_array[$i][2];
							
							break;
						
						}//if-end
					
					}//for-end
					
					$cost = (int)$cost_quote;
					
					$cost_text = $this->currency->format( $cost );
					
					$quote_data['japan_post'] = array(
								'id'           => 'japan_post.japan_post',
								'title'        => $this->language->get('text_title'),
								'cost'         => $cost,
								'tax_class_id' => 0,
								'text'         => $cost_text
							);
					break;
			
			}//switch-end
			
			
			$select_time_str = '';
			
			if( $this->config->get('japan_post_time_status') ){
			
				$select_time_array = explode( "\n", $this->config->get('japan_post_time') );
				
				$select_time_str = '<script type="text/javascript">' . "\n"
					 . 'function showInputJapanPost(form){
						
						 if( form.japan_post_stop.selectedIndex == 0 ){
							
							 $("#stopJapanPost").show("fast");
			
						 }else{
						 
							$("#stopJapanPost").hide("fast");
							
						 }
		
					   }
		
		</script>' . "\n";
		
				$select_time_str .= '&nbsp;&nbsp;配達指定&nbsp;<select style="font-weight:normal" name ="japan_post_stop" onchange="showInputJapanPost(this.form)">' . "\n";
				//郵便局留めの場合
				if( $this->config->get('japan_post_stop') ){
				
					
		
					$select_time_str .= '<option value="0">郵便局留め</option>' . "\n";
					
					$post_stop = '<div id="stopJapanPost" style="float:right">郵便局名を記載してください<input type="text" name="stop" /><br /><a href="http://www.post.japanpost.jp/shiten_search/index.html" target="_blank" style="text-decoration:underline; color:#FF0000;">郵便局を探す</a></div>';
					
				}else{
				
					$post_stop = '';
				
				}
				
				if( is_array($select_time_array) ){
					
					foreach( $select_time_array as $value ){
					
						if( !empty($value) ){
						
							$select_time_str .= '<option>' . $value . '</option>' . "\n";
							
						}//if-end
						
					}//foreach-end
					
				}//if-end
				
				
				$select_time_str .= '</select>' . $post_stop;
				
				if( empty($select_time_array) ){
				
					$select_time_str = '';
					
				}
				
			}//if-end
			
			if( (int)$address['country_id'] !== 107 ){
				
					$error = 'ゆうパックは日本国内以外では使用できません。';
				
			}
				
				$method_data = array(
						'id'         => 'japan_post',
						'title'      => $this->language->get('text_title') . $select_time_str,
						'quote'      => $quote_data,
						'sort_order' => $this->config->get('japan_post_sort_order'),
						'error'      => $error 
					);
			
			}else{
			
				$status = FALSE;
				
				$method_data = array();
				
				$quote_data = array();
			
			}
			
		return $method_data;
		
	}//function-end
	
}//class-end

?>