<?php
/*
 * Created on  2010/03/26
 * Filename    jpayment.php
 * Project     opencart142
 * Support     http://forum.opencart.jp/
 * Author      http://officesoya.net/ I.Suzuki
 *
 */
class ControllerPaymentJpayment extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('payment/jpayment');

		$this->document->title = $this->language->get('heading_title');

		$this->load->model('setting/setting');


		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');

			$this->model_setting_setting->editSetting('jpayment', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/payment');
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');

		$this->data['entry_merchant_id'] = $this->language->get('entry_merchant_id');
		$this->data['entry_job_type'] = $this->language->get('entry_job_type');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['merchant_id'])) {
			$this->data['error_merchant_id'] = $this->error['merchant_id'];
		} else {
			$this->data['error_merchant_id'] = '';
		}



  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home',
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=extension/payment',
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=payment/jpayment',
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = HTTPS_SERVER . 'index.php?route=payment/jpayment';

		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/payment';

		if (isset($this->request->post['jpayment_merchant_id'])) {
			$this->data['jpayment_merchant_id'] = $this->request->post['jpayment_merchant_id'];
		} else {
			$this->data['jpayment_merchant_id'] = $this->config->get('jpayment_merchant_id');
		}

		if (isset($this->request->post['jpayment_job_type'])) {
			$this->data['jpayment_job_type'] = $this->request->post['jpayment_job_type'];
		} else {
			$this->data['jpayment_job_type'] = $this->config->get('jpayment_job_type');
		}

		if (isset($this->request->post['jpayment_order_status_id'])) {
			$this->data['jpayment_order_status_id'] = $this->request->post['jpayment_order_status_id'];
		} else {
			$this->data['jpayment_order_status_id'] = $this->config->get('jpayment_order_status_id');
		}

		$this->load->model('localisation/order_status');

		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['jpayment_geo_zone_id'])) {
			$this->data['jpayment_geo_zone_id'] = $this->request->post['jpayment_geo_zone_id'];
		} else {
			$this->data['jpayment_geo_zone_id'] = $this->config->get('jpayment_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['jpayment_status'])) {
			$this->data['jpayment_status'] = $this->request->post['jpayment_status'];
		} else {
			$this->data['jpayment_status'] = $this->config->get('jpayment_status');
		}

		if (isset($this->request->post['jpayment_sort_order'])) {
			$this->data['jpayment_sort_order'] = $this->request->post['jpayment_sort_order'];
		} else {
			$this->data['jpayment_sort_order'] = $this->config->get('jpayment_sort_order');
		}

		$this->template = 'payment/jpayment.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/jpayment')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['jpayment_merchant_id']) {
			$this->error['merchant_id'] = $this->language->get('error_merchant_id');
		}



		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>