<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.2【日本語版】
// opencart.jp
// japan_post.php
// このファイルは、代引き手数料項目の追加モジュールです。
// ver 1.0.0 Coding By sae　seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
class ControllerTotalCodFee extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('total/cod_fee');

		$this->document->title = $this->language->get('heading_title');

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->model_setting_setting->editSetting('cod_fee', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/total');
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');

		$this->data['entry_total'] = $this->language->get('entry_total');
		$this->data['entry_fee'] = $this->language->get('entry_fee');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

   		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTP_SERVER . 'index.php?route=common/home',
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTP_SERVER . 'index.php?route=extension/total',
       		'text'      => $this->language->get('text_total'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTP_SERVER . 'index.php?route=total/cod_fee',
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = HTTPS_SERVER . 'index.php?route=total/cod_fee';

		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/total';

		if (isset($this->request->post['cod_fee_total'])) {
			$this->data['cod_fee_total'] = $this->request->post['cod_fee_total'];
		} else {
			$this->data['cod_fee_total'] = $this->config->get('cod_fee_total');
		}

		if (isset($this->request->post['cod_fee_fee'])) {
			$this->data['cod_fee_fee'] = $this->request->post['cod_fee_fee'];
		} else {
			$this->data['cod_fee_fee'] = $this->config->get('cod_fee_fee');
		}

		if (isset($this->request->post['cod_fee_status'])) {
			$this->data['cod_fee_status'] = $this->request->post['cod_fee_status'];
		} else {
			$this->data['cod_fee_status'] = $this->config->get('cod_fee_status');
		}

		if (isset($this->request->post['cod_fee_sort_order'])) {
			$this->data['cod_fee_sort_order'] = $this->request->post['cod_fee_sort_order'];
		} else {
			$this->data['cod_fee_sort_order'] = $this->config->get('cod_fee_sort_order');
		}

		$this->template = 'total/cod_fee.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'total/cod_fee')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>