<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.9【日本語版】
// opencart.jp
// remise.php
// ver 1.0.0 Coding By sae  2010/03/21 seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
class ModelPaymentRemise extends Model {
  	public function getMethod($address) {
		$this->load->language('payment/remise');

		if ($this->config->get('remise_status')) {

			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('remise_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

      		if (!$this->config->get('remise_geo_zone_id')) {
        		$status = TRUE;
      		} elseif ($query->num_rows) {
      		  	$status = TRUE;
      		} else {
     	  		$status = FALSE;
			}

      		$use_price = $this->config->get('remise_use_price');

			if( empty( $use_price) ){

				$use_price = 0;

      		}else{

      			$use_price = $this->config->get('remise_use_price');

      		}

			if( $this->cart->getTotal() < $use_price ){
				$status = FALSE;
			}
      	} else {
			$status = FALSE;
		}

		$method_data = array();

		if ($status) {
      		$method_data = array(
        		'id'         => 'remise',
        		'title'      => $this->config->get('remise_title'),
				'sort_order' => $this->config->get('remise_sort_order')
      		);
    	}

    	$price = $this->currency->format($this->config->get('remise_use_price'), '', $this->config->get('config_tax'));

    	if($this->config->get('remise_status') && $this->cart->getTotal() < $use_price ){
    		$method_data = array(
        		'id'         => 'remise',
        		'title'      => $this->config->get('remise_title') . sprintf($this->language->get('text_remise_use_price') , $price ) . '<script type="text/javascript">$("#remise").attr("disabled","desabled");</script>',
				'sort_order' => $this->config->get('remise_sort_order')
      		);
    	}

    	//円建てでなくては使用できないようにする。
  		if($this->config->get('remise_status') && $this->session->data['currency'] !== 'JPY' ){
    		$method_data = array(
        		'id'         => 'remise',
        		'title'      => $this->config->get('remise_title') . $this->language->get('text_currency') . '<script type="text/javascript">$("#remise").attr("disabled","desabled");</script>',
				'sort_order' => $this->config->get('remise_sort_order')
      		);
    	}

    	return $method_data;
  	}

  	public function getPayQuickId(){

  		if( isset( $this->session->data['customer_id'] ) ){

  			$sql = 'SELECT payquick_id FROM ' . DB_PREFIX . 'remise_payquick WHERE customer_id = "' . $this->session->data['customer_id'] . '"';

  			$result = $this->db->query( $sql );

  			//$payquick_id = $result->row['payquick_id'];

  			if(!empty($result->row['payquick_id'])){

  				$payquick_id = $result->row['payquick_id'];

  				return $payquick_id;

  			}else{

  				$payquick_id = FALSE;

  			}

  		}

  	}

  	public function addPayQuickId($payquick_id){

  		if( isset($this->request->post['X-PAYQUICKID']) && isset($this->request->post['X-S_TORIHIKI_NO'])){

  			$sql = 'SELECT customer_id FROM `' . DB_PREFIX . 'order` WHERE order_id = "' . $this->db->escape($this->request->post['X-S_TORIHIKI_NO']) . '"';

  			$result = $this->db->query($sql);

  			$customer_id = (int)$result->row['customer_id'];

  			$sql = 'DELETE FROM ' . DB_PREFIX . 'remise_payquick WHERE customer_id = "' . $customer_id . '"';

  			$this->db->query($sql);

  			$sql = 'INSERT INTO ' . DB_PREFIX . 'remise_payquick SET customer_id = "' . $customer_id . '", payquick_id = "' . $this->db->escape($payquick_id) . '"';

  			$this->db->query( $sql );

  		}

  	}

  	public function checkPayQuickId( $order_id ){

  		if( !empty($order_id) ){

  			$sql = 'SELECT order_id, total FROM `' . DB_PREFIX . 'order` WHERE order_id = "' . $order_id . '" AND total = "' . $this->request->post['X-TOTAL'] . '.0000"';

  			$result = $this->db->query($sql);

  			if($result->row['total'] == $this->request->post['X-TOTAL'] && $order_id == $result->row['order_id'] ){

  				return TRUE;

  			}else{

  				return FALSE;

  			}

  		}else{

  			return FALSE;

  		}

  	}

}
?>